"""create_invitation

Revision ID: 06e9066f56ad
Revises: c3071f877705
Create Date: 2022-07-20 10:32:46.232248+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '06e9066f56ad'
down_revision = 'c3071f877705'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('invitation',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('partner_id', sa.BigInteger(), nullable=False),
    sa.Column('requestor_uid', sa.BigInteger(), nullable=False),
    sa.Column('email', sa.Text(), nullable=False),
    sa.Column('invited_partner_id', sa.BigInteger(), nullable=False),
    sa.Column('status', sa.Text(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.CheckConstraint("status in ('sent', 'accepted', 'revoked')", name=op.f('invitation__validate_status__ck')),
    sa.PrimaryKeyConstraint('id', name=op.f('invitation__pk')),
    schema='ord'
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('invitation', schema='ord')
    # ### end Alembic commands ###
