"""cleanup

Revision ID: eaf06fa996db
Revises: 3af1ec8a0e3d
Create Date: 2022-07-24 16:43:06.817646+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'eaf06fa996db'
down_revision = '3af1ec8a0e3d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('report_row_ad_distributor_act_map', schema='ord')
    op.drop_table('ad_distributor_act', schema='ord')
    op.drop_constraint('client_row_client_act__client_act_id__fk', 'client_row', schema='ord', type_='foreignkey')
    op.drop_constraint('client_row_client_contract__client_contract_id__fk', 'client_row', schema='ord', type_='foreignkey')
    op.drop_table('client_act', schema='ord')
    op.drop_table('client_contract', schema='ord')
    op.drop_table('client_legal_entity_map', schema='ord')
    op.drop_table('legal_entity', schema='ord')
    op.drop_index('report_row__report_id_client_id_inn_act_eid__idx', table_name='report_row', schema='ord')
    op.drop_table('report_row', schema='ord')
    op.drop_index('client_row__client_ad_distr_act_campaign_client_act__idx', table_name='client_row', schema='ord')
    op.drop_column('client_row', 'client_contract_id', schema='ord')
    op.drop_column('client_row', 'client_act_id', schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('client_row', sa.Column('client_act_id', sa.BIGINT(), autoincrement=False, nullable=True), schema='ord')
    op.add_column('client_row', sa.Column('client_contract_id', sa.BIGINT(), autoincrement=False, nullable=True), schema='ord')
    op.create_foreign_key('client_row_client_contract__client_contract_id__fk', 'client_row', 'client_contract', ['client_contract_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.create_foreign_key('client_row_client_act__client_act_id__fk', 'client_row', 'client_act', ['client_act_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.create_index('client_row__client_ad_distr_act_campaign_client_act__idx', 'client_row', ['client_id', 'ad_distributor_act_id', 'campaign_id', 'client_act_id'], unique=False, schema='ord')
    op.create_table('client_legal_entity_map',
        sa.Column('client_id', sa.BIGINT(), autoincrement=False, nullable=False),
        sa.Column('legal_entity_id', sa.BIGINT(), autoincrement=False, nullable=False),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['client_id'], ['ord.client.id'], name='client_legal_entity_map_client__client_id__fk'),
        sa.ForeignKeyConstraint(['legal_entity_id'], ['ord.legal_entity.id'], name='client_legal_entity_map_legal_entity__legal_entity_id__fk'),
        sa.PrimaryKeyConstraint('client_id', 'legal_entity_id', name='client_legal_entity_map__pk'),
        schema='ord'
    )
    op.create_table('report_row',
        sa.Column('id', sa.BIGINT(), server_default=sa.text("nextval('ord.report_row_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('report_id', sa.BIGINT(), autoincrement=False, nullable=False),
        sa.Column('client_id', sa.BIGINT(), autoincrement=False, nullable=False),
        sa.Column('contract_eid', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('inn', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('act_eid', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('amount', sa.NUMERIC(precision=18, scale=6), autoincrement=False, nullable=True),
        sa.Column('suggested_amount', sa.NUMERIC(precision=18, scale=6), autoincrement=False, nullable=True),
        sa.Column('is_yt', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column('is_valid', sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column('vat', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('currency', sa.TEXT(), server_default=sa.text("'RUB'::text"), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(['client_id'], ['ord.client.id'], name='report_row_client__client_id__fk'),
        sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name='report_row_report__report_id__fk'),
        sa.PrimaryKeyConstraint('id', name='report_row__pk'),
        schema='ord',
        postgresql_ignore_search_path=False
    )
    op.create_index('report_row__report_id_client_id_inn_act_eid__idx', 'report_row', ['report_id', 'client_id', 'inn', 'act_eid'], unique=False, schema='ord')
    op.create_table('legal_entity',
        sa.Column('id', sa.BIGINT(), server_default=sa.text("nextval('ord.legal_entity_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('contract_eid', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('inn', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('vat', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('currency', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('agency_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('name', sa.TEXT(), autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint('id', name='legal_entity__pk'),
        schema='ord',
        postgresql_ignore_search_path=False
    )
    op.create_table('client_contract',
        sa.Column('id', sa.BIGINT(), server_default=sa.text("nextval('ord.client_contract_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('legal_entity_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('file_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('contract_eid', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('vat', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('currency', sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['file_id'], ['ord.s3_mds_file.id'], name='client_contract_s3_mds_file__file_id__fk'),
        sa.ForeignKeyConstraint(['legal_entity_id'], ['ord.legal_entity.id'], name='client_contract_legal_entity__legal_entity_id__fk'),
        sa.PrimaryKeyConstraint('id', name='client_contract__pk'),
        sa.UniqueConstraint('legal_entity_id', 'contract_eid', name='client_contract__legal_entity_id__uq'),
        schema='ord'
    )
    op.create_table('report_row_ad_distributor_act_map',
        sa.Column('ad_distributor_act_id', sa.BIGINT(), autoincrement=False, nullable=False),
        sa.Column('report_row_id', sa.BIGINT(), autoincrement=False, nullable=False),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['ad_distributor_act_id'], ['ord.ad_distributor_act.id'], name='report_row_ad_distributor_act_map_ad_distributor_act__a_1f63'),
        sa.ForeignKeyConstraint(['report_row_id'], ['ord.report_row.id'], name='report_row_ad_distributor_act_map_report_row__report_row_id__fk'),
        sa.PrimaryKeyConstraint('report_row_id', 'ad_distributor_act_id', name='report_row_ad_distributor_act_map__pk'),
        schema='ord'
    )
    op.create_table('client_act',
        sa.Column('id', sa.BIGINT(), server_default=sa.text("nextval('ord.client_act_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('report_id', sa.BIGINT(), autoincrement=False, nullable=False),
        sa.Column('act_eid', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('amount', sa.NUMERIC(precision=18, scale=6), autoincrement=False, nullable=True),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('legal_entity_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('file_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(['file_id'], ['ord.s3_mds_file.id'], name='client_act_s3_mds_file__file_id__fk'),
        sa.ForeignKeyConstraint(['legal_entity_id'], ['ord.legal_entity.id'], name='client_act_legal_entity__legal_entity_id__fk'),
        sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name='client_act_report__report_id__fk'),
        sa.PrimaryKeyConstraint('id', name='client_act__pk'),
        sa.UniqueConstraint('report_id', 'act_eid', name='client_act__report_id__uq'),
        schema='ord'
    )
    op.create_table('ad_distributor_act',
        sa.Column('id', sa.BIGINT(), server_default=sa.text("nextval('ord.ad_distributor_act_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('act_eid', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('amount', sa.NUMERIC(precision=18, scale=6), autoincrement=False, nullable=True),
        sa.Column('file_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('report_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('is_common', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(['file_id'], ['ord.s3_mds_file.id'], name='ad_distributor_act_s3_mds_file__file_id__fk'),
        sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name='ad_distributor_act_report__report_id__fk'),
        sa.PrimaryKeyConstraint('id', name='ad_distributor_act__pk'),
        sa.UniqueConstraint('report_id', 'act_eid', name='ad_distributor_act__report_id__uq'),
        schema='ord'
    )
    # ### end Alembic commands ###
