import asyncio
import logging.config

from gino.dialects.asyncpg import Pyscopg2Pool

from crm.agency_cabinet.ord.common import QUEUE
from crm.agency_cabinet.ord.server.src.config import OrdConfig
from crm.agency_cabinet.common.server.common.config import MdsConfig
from crm.agency_cabinet.ord.server.src.db.engine import db
from crm.agency_cabinet.ord.server.src.handler import Handler
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.common.server.common.logging_config import get_logging_config
from crm.agency_cabinet.common.monitoring.utils.server import run_ping_service
from crm.agency_cabinet.common.monitoring.utils.registry import setup_monitoring

__all__ = ['run_server']


def run_server():
    cfg = OrdConfig.from_environ()
    mds_cfg = MdsConfig.from_environ()
    logging.config.dictConfig(get_logging_config(cfg.verbose))

    asyncio.run(_run_server(cfg, mds_cfg))


async def _run_server(cfg: OrdConfig, mds_cfg: MdsConfig):
    await db.set_bind(bind=str(cfg.db.get_dsn()), pool_class=Pyscopg2Pool, ssl='verify-full')
    metric_registry = setup_monitoring()
    async with ServiceDiscovery(cfg.amqp_url, with_rpc_client=False) as sd:  # type: ServiceDiscovery
        handler = Handler(mds_cfg)

        async with sd.rpc_server(QUEUE) as server:
            await handler.setup()
            await asyncio.gather(server.drain(handler), run_ping_service(metric_registry))
