from crm.agency_cabinet.ord.server.src import config
from crm.agency_cabinet.ord.server.src.db.engine import db
from crm.agency_cabinet.ord.server.src.config import MDS_SETTINGS
from crm.agency_cabinet.common.celery.base import ContextTask, BotoSessionBoundedMixin, CeleryAppFactoryContextTask


class OrdContextTask(ContextTask):
    pass


class OrdContextBoto3Task(OrdContextTask, BotoSessionBoundedMixin):
    pass


class OrdCeleryAppFactory(CeleryAppFactoryContextTask):
    def post_create(self, *args, **kwargs):
        super(OrdCeleryAppFactory, self).post_create(*args, **kwargs)
        OrdContextBoto3Task.init_mds_params(
            MDS_SETTINGS['access_key_id'],
            MDS_SETTINGS['secret_access_key'],
            MDS_SETTINGS['endpoint_url'])


celery_app = OrdCeleryAppFactory('ord_tasks',
                                 scheduler_lock_settings=config.SCHEDULER_LOCK_SETTINGS,
                                 celery_settings=config.CELERY_SETTINGS,
                                 task_class=OrdContextTask,
                                 db=db,
                                 db_config=config.db_config.db
                                 ).create()
