from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from crm.agency_cabinet.common.yt.loaders import YqlLoader
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from .synchronizer import ReportsSynchronizer


class ReportsLoader(YqlLoader):
    YQL_QUERY = '''
        USE hahn;

        DECLARE $netting_act_table_path AS String;
        DECLARE $direct_dump_root AS String;

        SELECT
            netting_acts.agency_id,
            netting_acts.client_id,
            SUM(netting_acts.acted_sum),
            netting_acts.act_id,
            netting_acts.act_external_id,
            users.login,
            clients.name,
            netting_acts.service_order_id,
            netting_acts.order_text,
        FROM $netting_act_table_path AS netting_acts
        LEFT JOIN LIKE(
            $direct_dump_root,
            `ppc:%`,
            `straight/clients`
        ) AS clients
            ON netting_acts.client_id=clients.ClientID
        LEFT JOIN LIKE(
            $direct_dump_root,
            `ppc:%`,
            `straight/users`
        ) AS users
            ON clients.chief_uid = users.uid
        {}
        GROUP BY
            netting_acts.agency_id,
            netting_acts.client_id,
            netting_acts.act_id,
            netting_acts.act_external_id,
            users.login,
            clients.name,
            netting_acts.service_order_id,
            netting_acts.order_text
    '''

    def yql_query(self):
        if self.agency_id is not None:
            return self.YQL_QUERY.format(f'WHERE netting_acts.agency_id=={self.agency_id}')
        else:
            return self.YQL_QUERY.format('')

    def __init__(self,
                 yt_client: YtClient,
                 yql_client: YqlClient,
                 netting_act_table_path: str,
                 direct_dump_root: str,
                 period_from,
                 agency_id,
                 sd: ServiceDiscovery):
        self.period_from = period_from
        self.sd = sd
        self.agency_id = agency_id

        super().__init__(
            yt_client, yql_client,
            yql_parameters={
                '$direct_dump_root': YqlParameterValueBuilder.make_string(direct_dump_root),
                '$netting_act_table_path': YqlParameterValueBuilder.make_string(netting_act_table_path),
            },
            table_paths=[netting_act_table_path],
        )

    async def _load(self, *args, **kwargs) -> bool:
        results = await self._get_results()
        data = results.table.get_iterator()
        return await ReportsSynchronizer(self.period_from, self.sd).process_data(data)
