import logging

from .base import BaseReportExporter
from crm.agency_cabinet.ord.server.src.celery.tasks.transfer.format import AGENCY_DIRECT_HEADERS, ALL_CAMPAIGNS, \
    IsVatConverter

LOGGER = logging.getLogger('celery.export_reports.agency_yandex')


class AgencyDirectReportExporter(BaseReportExporter):
    HEADERS = AGENCY_DIRECT_HEADERS

    async def _get_report_data(self):
        prev_client_eid = None
        async for row in self._fetch_data_from_db():
            if prev_client_eid is None or prev_client_eid != row.client_eid:
                # TODO implement
                yield [
                    row.client_eid,
                    row.client_login,
                    ALL_CAMPAIGNS
                ]
                prev_client_eid = row.client_eid

            yield [
                # Логин/Кампания
                row.client_eid,
                row.client_login,
                row.campaign_name,
                row.suggested_amount,
                row.campaign_eid,

                # Площадка
                row.ad_distributor_act_eid,
                row.ad_distributor_act_amount,
                IsVatConverter.to_str(row.ad_distributor_act_is_vat),

                # Я-Агентство
                row.ad_distributor_partner_org_inn,
                row.ad_distributor_partner_org_type,
                row.ad_distributor_partner_org_name,
                row.ad_distributor_partner_org_mobile_phone,
                row.ad_distributor_partner_org_epay_number,
                row.ad_distributor_partner_org_reg_number,
                row.ad_distributor_partner_org_alter_inn,
                row.ad_distributor_partner_org_oksm_number,

                # Мой контрагент
                row.partner_client_org_inn,
                row.partner_client_org_type,
                row.partner_client_org_name,
                row.partner_client_org_mobile_phone,
                row.partner_client_org_epay_number,
                row.partner_client_org_reg_number,
                row.partner_client_org_alter_inn,
                row.partner_client_org_oksm_number,

                # Договор между агентством и его контрагентом
                row.partner_contract_eid,
                row.partner_contract_type,
                row.partner_contract_action_type,
                row.partner_contract_subject_type,
                row.partner_contract_date.strftime('%Y-%m-%d') if row.partner_contract_date else None,
                row.partner_contract_amount,
                IsVatConverter.to_str(row.partner_contract_is_vat),
                row.partner_act_eid,
                row.partner_act_amount,
                IsVatConverter.to_str(row.partner_act_is_vat),
                row.advertiser_contract_id == row.partner_contract_id and row.partner_contract_id is not None,

                # Контрагент конечного рекламодателя
                row.advertiser_contractor_org_inn,
                row.advertiser_contractor_org_type,
                row.advertiser_contractor_org_name,
                row.advertiser_contractor_org_mobile_phone,
                row.advertiser_contractor_org_epay_number,
                row.advertiser_contractor_org_reg_number,
                row.advertiser_contractor_org_alter_inn,
                row.advertiser_contractor_org_oksm_number,

                # Конечный рекламодатель
                row.advertiser_org_inn,
                row.advertiser_org_type,
                row.advertiser_org_name,
                row.advertiser_org_mobile_phone,
                row.advertiser_org_epay_number,
                row.advertiser_org_reg_number,
                row.advertiser_org_alter_inn,
                row.advertiser_org_oksm_number,

                # Договор между конечным рекламодателем и его исполнителем
                row.advertiser_contract_eid,
                row.advertiser_contract_type,
                row.advertiser_contract_action_type,
                row.advertiser_contract_subject_type,
                row.advertiser_contract_date.strftime('%Y-%m-%d') if row.advertiser_contract_date else None,
                row.advertiser_contract_amount,
                IsVatConverter.to_str(row.advertiser_contract_is_vat)
            ]
