ALL_CAMPAIGNS = 'Все кампании'

CLIENT_HEADERS = [
    'Client ID',
    'Login',
]

CAMPAIGN_HEADERS = [
    'Рекламная кампания',
    'Рекомендуемая сумма (с НДС)',
    'Идентификатор креатива',
]

ACT_HEADERS = [
    'Акт',
    'Сумма (с НДС)',
    'Признак "с НДС"',
]

ORGANIZATION_HEADERS = [
    'ИНН',
    'Тип организации',
    'ОПФ и полное наименование',
    'Абонентский номер мобильного телефона',
    'Номер электронного средства платежа',
    'Регистрационный номер либо его аналог',
    'Номер налогоплательщика либо его аналог в стране регистрации',
    'Код страны регистрации юрлица в соответствии с ОКСМ',
]

CONTRACT_HEADERS = [
    'Номер договора',
    'Тип договора',
    'Описание осуществляемых посредником-представителем действий',
    'Сведения о предмете договора',
    'Дата договора / доп.соглашения',
    'Цена договора',
    'Признак "с НДС"',
]

AGENCY_DIRECT_HEADERS = {
    'Логин/Кампания': [
        CLIENT_HEADERS,
        CAMPAIGN_HEADERS
    ],
    'Площадка': [ACT_HEADERS],
    'Я-Агентство': [ORGANIZATION_HEADERS],
    'Мой контрагент': [ORGANIZATION_HEADERS],
    'Договор между агентством и его контрагентом': [
        CONTRACT_HEADERS,
        ACT_HEADERS,
        ['Мой контрагент является конечным']
    ],
    'Контрагент конечного рекламодателя': [ORGANIZATION_HEADERS],
    'Конечный рекламодатель': [ORGANIZATION_HEADERS],
    'Договор между конечным рекламодателем и его исполнителем': [CONTRACT_HEADERS]
}


class IsVatConverter:
    @staticmethod
    def from_str(s: str):
        if s is None:
            return None

        if s.lower() == 'да':
            return True

        if s.lower() == 'нет':
            return False

        return None

    @staticmethod
    def to_str(b: bool):
        if b is None:
            return None

        return 'да' if b else 'нет'
