from .base import BaseReportImporter, ImportReportException
from crm.agency_cabinet.ord.server.src.celery.tasks.transfer.format import AGENCY_DIRECT_HEADERS, ALL_CAMPAIGNS


class UnknownClientException(ImportReportException):
    pass


class UnknownCampaignException(ImportReportException):
    pass


class UnknownActAdDistributorException(ImportReportException):
    pass


class CampaignAdDistributorActMismatch(ImportReportException):
    pass


class UnknownPartnerOrganization(ImportReportException):
    pass


class AgencyDirectReportImporter(BaseReportImporter):
    HEADERS = AGENCY_DIRECT_HEADERS

    async def _load_row(self, row):
        # TODO обработать 'Мой контрагент является конечным'
        client_data, \
        campaign_data, \
        ad_distributor_act_data, \
        ad_distributor_partner_org_data, \
        partner_client_org_data, \
        partner_contract_data, \
        partner_act_data, \
        _, \
        advertiser_contractor_org_data, \
        advertiser_org_data, \
        advertiser_contract_data = self._get_sliced_data(row)

        # Кампания
        campaign_eid = campaign_data[2]

        if campaign_data[0] == ALL_CAMPAIGNS:
            # TODO implement
            return

        if campaign_eid not in self.campaigns:
            raise UnknownCampaignException()

        campaign_id = self.campaigns[campaign_eid]['id']
        suggested_amount = self.campaigns[campaign_eid]['suggested_amount']

        # Логин
        client_eid = client_data[0]
        if client_eid not in self.clients:
            raise UnknownClientException()

        client_id = self.clients[client_eid]['id']

        # Площадка
        ad_distributor_act_eid = ad_distributor_act_data[0]
        key = (campaign_eid, ad_distributor_act_eid)
        if key not in self.ad_distributor_acts:
            raise UnknownActAdDistributorException()

        ad_distributor_act_id = self.ad_distributor_acts[key]['id']
        ad_distributor_contract_id = self.ad_distributor_contracts[ad_distributor_act_id]['id']

        # Я-Агентство
        ad_distributor_partner_org_id = await self._update_or_create_organization(
            ad_distributor_partner_org_data,
            self.ad_distributor_partner_orgs
        )

        # Мой контрагент
        partner_client_org_id = await self._update_or_create_organization(
            partner_client_org_data,
            self.partner_client_orgs
        )

        # Договор между агентством и его контрагентом
        partner_contract_id = await self._update_or_create_contract(
            partner_client_org_id,
            ad_distributor_partner_org_id,
            partner_contract_data,
            self.partner_contracts
        )

        partner_act_id = await self._update_or_create_act(partner_act_data, self.partner_acts)

        # Контрагент конечного рекламодателя
        advertiser_contractor_org_id = await self._update_or_create_organization(
            advertiser_contractor_org_data,
            self.advertiser_contractor_orgs
        )

        # Конечный рекламодатель
        advertiser_org_id = await self._update_or_create_organization(advertiser_org_data, self.advertiser_orgs)

        # Договор между конечным рекламодателем и его исполнителем
        advertiser_contract_id = await self._update_or_create_contract(
            advertiser_org_id,
            advertiser_contractor_org_id,
            advertiser_contract_data,
            self.advertiser_contracts
        )

        key = (campaign_eid, ad_distributor_act_eid)
        self.new_client_rows[key].append(
            {
                'client_id': client_id,
                'campaign_id': campaign_id,
                'suggested_amount': suggested_amount,
                'ad_distributor_act_id': ad_distributor_act_id,
                'ad_distributor_contract_id': ad_distributor_contract_id,
                'partner_contract_id': partner_contract_id,
                'advertiser_contract_id': advertiser_contract_id,
                'partner_act_id': partner_act_id
            }
        )

    async def after_load(self):
        if len(self.new_client_rows) != len(self.client_rows):
            raise CampaignAdDistributorActMismatch()

        for (campaign_eid, ad_distributor_act_eid), client_row_data in self.new_client_rows.items():
            current_client_row_data = self.client_rows[(campaign_eid, ad_distributor_act_eid)]

            replace_current_data = False

            if len(current_client_row_data) != len(client_row_data):
                replace_current_data = True
            else:
                # TODO better
                s1 = set()
                for row in client_row_data:
                    s1.add(
                        (
                            row['ad_distributor_act_id'],
                            row['ad_distributor_contract_id'],
                            row['partner_contract_id'],
                            row['advertiser_contract_id'],
                            row['partner_act_id']
                        )
                    )

                s2 = set()
                for row in current_client_row_data:
                    s2.add(
                        (
                            row['ad_distributor_act_id'],
                            row['ad_distributor_contract_id'],
                            row['partner_contract_id'],
                            row['advertiser_contract_id'],
                            row['partner_act_id']
                        )
                    )

                replace_current_data = (s1 != s2)

            if replace_current_data:
                campaign_id = client_row_data[0]['campaign_id']
                ad_distributor_act_id = client_row_data[0]['ad_distributor_act_id']
                await self._delete_client_rows(campaign_id, ad_distributor_act_id)

                for i in client_row_data:
                    await self._create_client_row(
                        **i
                    )
