import environ
from environs import Env
from gino.dialects.asyncpg import Pyscopg2Pool
from sqlalchemy.engine.url import URL

from crm.agency_cabinet.common.server.rpc.config import RpcServerConfig

env = Env()


@environ.config(prefix='')
class OrdConfig(RpcServerConfig):
    pass


class Settings:
    db = {
        'dsn': URL(
            drivername='postgresql',
            username=env('PG_LOCAL_USER', 'postgres'),
            password=env('PG_LOCAL_PASSWORD', 'postgres'),
            host=env('PG_LOCAL_HOST', 'localhost'),
            port=env.int('PG_LOCAL_PORT', 5432),
            database=env('PG_LOCAL_DATABASE', 'postgres'),
        ),
        'ssl': env('PG_SSL', 'verify-full'),
        'pool_class': Pyscopg2Pool
    }


db_config = Settings()

gino_metadata_settings = {
    'schema': 'ord',
    'naming_convention': {
        'ix': '%(table_name)__%(column_0_name)s__idx',
        'uq': '%(table_name)s__%(column_0_name)s__uq',
        'ck': '%(table_name)s__%(constraint_name)s__ck',
        'fk': '%(table_name)s_%(referred_table_name)s__%(column_0_name)s__fk',
        'pk': '%(table_name)s__pk'
    }
}

SQS_SETTINGS = {
    'SQS_ACCESS_KEY': env('AWS_ACCESS_KEY_ID', 'agency-cabinet-test'),
    'SQS_SECRET_KEY': env('AWS_SECRET_ACCESS_KEY', 'unused'),
    'SQS_URL': env('SQS_URL', 'sqs.yandex.net:8771'),
    'SQS_OAUTH_TOKEN': env('AWS_SESSION_TOKEN', '')

}
# TODO: сделать, чтобы было без этой фигни (см. патч в chats/понять почему работает в аддаптере?)
# IMPORTANT: DO NOT SPECIFY NEITHER ACCESS_KEY NOR SECRET_KEY HERE
# They should be passed with session token in env vars, otherwise celery will
# take them from params, ignoring session token in env var
SQS_ENDPOINT = f'sqs://{SQS_SETTINGS["SQS_URL"]}'

CELERY_SETTINGS = {
    'broker_url': SQS_ENDPOINT if env.bool('USE_SQS', True) else env('BROKER_URL', 'redis://localhost:6379'),
    'result_expires': None,  # despite we don't use result_backend (i.e. DisabledBackend), celery beat generates
    'task_routes': {  # task to clean up dummy backend; remove if/when we use result_backend
        'crm.agency_cabinet.ord.server.src.celery.tasks.*': {
            'queue': 'ord'
        }
    },
    'imports': ['crm.agency_cabinet.common.celery.signals', 'crm.agency_cabinet.ord.server.src.celery.tasks'],
    'beat_schedule': {
        "export_report": {
            "task": "crm.agency_cabinet.ord.server.src.celery.tasks.check_requested_export_reports_task",
            "schedule": env.float('CHECK_REPORTS_INTERVAL', 30),
            "options": {
                "queue": "ord",
            },
        },
        "import_report": {
            "task": "crm.agency_cabinet.ord.server.src.celery.tasks.check_requested_import_reports_task",
            "schedule": env.float('CHECK_REPORTS_INTERVAL', 30),
            "options": {
                "queue": "ord",
            },
        },
    },
    'beat_scheduler': 'crm.agency_cabinet.common.celery.scheduler.LockedPersistentScheduler',
    'broker_transport_options': {
        'is_secure': False,
        'region': 'yandex',
    }
}

# TODO: move to common
SCHEDULER_LOCK_SETTINGS = {
    'proxy': env('SCHEDULER_LOCK_PROXY', 'freud'),
    'prefix': env('SCHEDULER_LOCK_PREFIX', 'tmp'),
    'token': env('YT_TOKEN', None),
    'lock_params': {
        'lock_key': env('SCHEDULER_LOCK_KEY', 'ord-celerybeat-lock'),  # + env?
        'next_try_timeout': 30
    }
}

YT_CONFIG = {
    'TOKEN': env('YT_TOKEN', None)
}

YQL_CONFIG = {
    'TOKEN': env('YQL_TOKEN', None)
}

MDS_SETTINGS = {
    'endpoint_url': env('MDS_ENDPOINT', 'https://s3.mds.yandex.net'),
    'endpoint_url_with_auth': env('MDS_ENDPOINT_WITH_AUTH', 'https://s3-private.mds.yandex.net'),
    'access_key_id': env('MDS_ACCESS_KEY_ID', None),
    'secret_access_key': env('MDS_SECRET_ACCESS_KEY', None)
}

REPORTS_MDS_SETTINGS = {
    'bucket': env('REPORTS_MDS_BUCKET', 'agency-cabinet-common'),
    'prefix': env('REPORTS_PATH_PREFIX', 'ord/export')
}
