from crm.agency_cabinet.common.db.models import BaseModel, db, NumericType


class Act(BaseModel):
    __tablename__ = 'act'

    id = db.Column(db.BigInteger, primary_key=True)
    report_id = db.Column(db.BigInteger, nullable=False)
    act_eid = db.Column(db.Text)
    amount = db.Column(NumericType)
    is_vat = db.Column(db.Boolean)
    is_valid = db.Column(db.Boolean, nullable=False, default=False, server_default='f')

    __table_args__ = (
        db.ForeignKeyConstraint(['report_id'], ['report.id']),
        db.UniqueConstraint('report_id', 'act_eid'),
    )
