from crm.agency_cabinet.common.db.models import BaseModel, db


class Campaign(BaseModel):
    __tablename__ = 'campaign'

    id = db.Column(db.BigInteger, primary_key=True)
    report_id = db.Column(db.BigInteger, nullable=False)
    client_id = db.Column(db.BigInteger, nullable=False)
    campaign_eid = db.Column(db.Text, nullable=False)
    name = db.Column(db.Text)

    __table_args__ = (
        db.ForeignKeyConstraint(['report_id'], ['report.id']),
        db.UniqueConstraint('report_id', 'campaign_eid'),
        db.ForeignKeyConstraint(['client_id'], ['client.id']),
        db.UniqueConstraint('client_id', 'campaign_eid')
    )
