from crm.agency_cabinet.common.db.models import BaseModel, db, NumericType


class Client(BaseModel):
    __tablename__ = 'client'

    id = db.Column(db.BigInteger, primary_key=True)
    client_id = db.Column(db.Text, nullable=False)
    report_id = db.Column(db.BigInteger, nullable=False)
    name = db.Column(db.Text, nullable=True)
    login = db.Column(db.Text, nullable=True)
    is_yt = db.Column(db.Boolean, nullable=False, default=True)

    __table_args__ = (
        db.ForeignKeyConstraint(['report_id'], ['report.id']),
        db.Index(
            'client__report_id_client_id__idx',
            'report_id', 'client_id',
            unique=True
        ),
    )


class ClientRow(BaseModel):
    __tablename__ = 'client_row'

    id = db.Column(db.BigInteger, primary_key=True)
    client_id = db.Column(db.BigInteger, nullable=False)
    campaign_id = db.Column(db.BigInteger, nullable=True)
    ad_distributor_contract_id = db.Column(db.BigInteger)
    ad_distributor_act_id = db.Column(db.BigInteger)
    partner_contract_id = db.Column(db.BigInteger)
    partner_act_id = db.Column(db.BigInteger)
    advertiser_contract_id = db.Column(db.BigInteger)
    suggested_amount = db.Column(NumericType)

    __table_args__ = (
        db.ForeignKeyConstraint(['client_id'], ['client.id']),
        db.ForeignKeyConstraint(['campaign_id'], ['campaign.id']),
        db.ForeignKeyConstraint(['ad_distributor_contract_id'], ['contract.id']),
        db.ForeignKeyConstraint(['partner_contract_id'], ['contract.id']),
        db.ForeignKeyConstraint(['advertiser_contract_id'], ['contract.id']),
        db.ForeignKeyConstraint(['partner_act_id'], ['act.id']),
        db.ForeignKeyConstraint(['ad_distributor_act_id'], ['act.id']),
    )
