from crm.agency_cabinet.common.db.models import BaseModel, db, NumericType
from crm.agency_cabinet.ord.common.consts import ContractType, ContractSubjectType, ContractActionType


class Contract(BaseModel):
    __tablename__ = 'contract'

    id = db.Column(db.BigInteger, primary_key=True)
    partner_id = db.Column(db.BigInteger, nullable=False)
    client_id = db.Column(db.BigInteger)
    contractor_id = db.Column(db.BigInteger)
    contract_eid = db.Column(db.Text)
    is_reg_report = db.Column(db.Boolean)
    type = db.Column(db.Text)
    action_type = db.Column(db.Text)
    subject_type = db.Column(db.Text)
    date = db.Column(db.DateTime(timezone=True))
    amount = db.Column(NumericType)
    is_vat = db.Column(db.Boolean)
    original_contract_eid = db.Column(db.Text)
    is_valid = db.Column(db.Boolean, nullable=False, default=False, server_default='f')

    __table_args__ = (
        db.ForeignKeyConstraint(['client_id'], ['organization.id']),
        db.ForeignKeyConstraint(['contractor_id'], ['organization.id']),
        db.UniqueConstraint('contract_eid', 'client_id', 'contractor_id'),
        db.CheckConstraint(
            f"""type in ({", ".join((f"'{e.value}'" for e in ContractType))})""",
            name='validate_contract_type'
        ),
        db.CheckConstraint(
            f"""subject_type in ({", ".join((f"'{e.value}'" for e in ContractSubjectType))})""",
            name='validate_subject_type'
        ),
        db.CheckConstraint(
            f"""action_type in ({", ".join((f"'{e.value}'" for e in ContractActionType))})""",
            name='validate_action_type'
        ),
    )
