from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.ord.common.consts import InvitationStatus


class Invitation(BaseModel):
    __tablename__ = 'invitation'

    id = db.Column(db.BigInteger, primary_key=True)
    partner_id = db.Column(db.BigInteger, nullable=False)
    requestor_uid = db.Column(db.BigInteger, nullable=False)
    email = db.Column(db.Text, nullable=False)
    invited_partner_id = db.Column(db.BigInteger, nullable=False)
    status = db.Column(db.Text, nullable=False)

    __table_args__ = (
        db.CheckConstraint(
            f"""status in ({", ".join((f"'{e.value}'" for e in InvitationStatus))})""",
            name='validate_status'
        )
    )
