from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.ord.common.consts import OrganizationType


class Organization(BaseModel):
    __tablename__ = 'organization'

    id = db.Column(db.BigInteger, primary_key=True)
    partner_id = db.Column(db.BigInteger, nullable=False)
    type = db.Column(db.Text)
    inn = db.Column(db.Text)
    name = db.Column(db.Text)
    is_rr = db.Column(db.Boolean)
    is_ors = db.Column(db.Boolean)
    mobile_phone = db.Column(db.Text)
    epay_number = db.Column(db.Text)
    reg_number = db.Column(db.Text)
    alter_inn = db.Column(db.Text)
    oksm_number = db.Column(db.Text)
    rs_url = db.Column(db.Text)
    is_valid = db.Column(db.Boolean, nullable=False, default=False, server_default='f')

    __table_args__ = (
        db.CheckConstraint(
            f"""type in ({", ".join((f"'{e.value}'" for e in OrganizationType))})""",
            name='validate_organization_type'
        )
    )
