from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.ord.common.consts import ReporterType


class Report(BaseModel):
    __tablename__ = 'report'

    id = db.Column(db.BigInteger, primary_key=True)
    agency_id = db.Column(db.BigInteger, nullable=False)  # TODO: rename -> partner_id
    settings_id = db.Column(db.BigInteger, nullable=False)
    reporter_type = db.Column(db.Text, nullable=False)
    period_from = db.Column(db.DateTime(timezone=True), nullable=False)
    status = db.Column(db.Text, nullable=False)
    sending_date = db.Column(db.DateTime(timezone=True))
    is_deleted = db.Column(db.Boolean, nullable=False, default=False)
    external_id = db.Column(db.Text, nullable=True)

    __table_args__ = (
        db.ForeignKeyConstraint(['settings_id'], ['report_settings.id']),
        db.CheckConstraint(
            f"""reporter_type in ({", ".join((f"'{e.value}'" for e in ReporterType))})""",
            name='validate_reporter_type'
        ),
    )
