from crm.agency_cabinet.common.server.common.structs import TaskStatuses
from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.ord.server.src.db.models import Report, S3MdsFile


class ReportExportInfo(BaseModel):
    __tablename__ = 'report_export_info'

    id = db.Column(db.BigInteger, primary_key=True)
    report_id = db.Column(db.BigInteger, nullable=False)
    file_id = db.Column(db.BigInteger, nullable=True)
    status = db.Column(db.Text, nullable=False, default=TaskStatuses.requested.value)  # TODO: make constraint based on possible constants

    __table_args__ = (
        db.ForeignKeyConstraint(['report_id'], ['report.id'], ondelete='CASCADE'),
        db.ForeignKeyConstraint(['file_id'], ['s3_mds_file.id']),
    )

    _file = None
    _report = None

    @property
    def report(self) -> Report:
        return self._report

    @report.setter
    def report(self, value: Report):
        self._report = value

    @property
    def file(self) -> S3MdsFile:
        return self._file

    @file.setter
    def file(self, value: S3MdsFile):
        self._file = value
