from crm.agency_cabinet.common.consts.report import ReportsStatuses
from crm.agency_cabinet.common.server.common.structs import TaskStatuses
from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.ord.server.src.db.models import Report, S3MdsFile


class ReportImportInfo(BaseModel):
    __tablename__ = 'report_import_info'

    id = db.Column(db.BigInteger, primary_key=True)
    report_id = db.Column(db.BigInteger, nullable=False)
    file_id = db.Column(db.BigInteger, nullable=True)
    status = db.Column(db.Text, nullable=False, default=ReportsStatuses.requested.value)  # TODO: make constraint based on possible constants

    __table_args__ = (
        db.ForeignKeyConstraint(['report_id'], ['report.id'], ondelete='CASCADE'),
        db.ForeignKeyConstraint(['file_id'], ['s3_mds_file.id']),
        db.Index('report_import_info__report_id_status__idx', report_id, status,
                 unique=True,
                 postgresql_where=(status.in_([TaskStatuses.requested.value, TaskStatuses.in_progress.value]))),
    )

    _file = None
    _report = None

    @property
    def report(self) -> Report:
        return self._report

    @report.setter
    def report(self, value: Report):
        self._report = value

    @property
    def file(self) -> S3MdsFile:
        return self._file

    @file.setter
    def file(self, value: S3MdsFile):
        self._file = value
