from sqlalchemy.dialects.postgresql import JSONB

from crm.agency_cabinet.common.utils.settings import settings_property
from crm.agency_cabinet.common.db.models import BaseModel, db


class ReportSettings(BaseModel):
    __tablename__ = 'report_settings'

    id = db.Column(db.BigInteger, primary_key=True)
    name = db.Column(db.Text, nullable=False, unique=True)
    display_name = db.Column(db.Text, nullable=False)
    settings = db.Column(JSONB, nullable=False, default=dict, server_default='{}')

    allow_create_ad_distributor_acts = settings_property('allow_create_ad_distributor_acts', True)
    allow_create_clients = settings_property('allow_create_clients', True)
    allow_create_campaigns = settings_property('allow_create_campaigns', True)
    allow_edit_report = settings_property('allow_edit_report', True)
