import asyncio

from dataclasses import dataclass
from crm.agency_cabinet.ord.server.src.db import db, models
from crm.agency_cabinet.ord.common import structs


@dataclass
class GetInvites:
    async def __call__(
        self,
        request: structs.GetInvitesInput,
    ) -> structs.InviteList:
        query = models.Invitation.query.where(
            models.Invitation.partner_id == request.agency_id
        )

        size_query = db.select(
            [db.func.count()]
        ).select_from(models.Invitation).where(
            models.Invitation.partner_id == request.agency_id
        )

        if request.limit is not None:
            query = query.limit(request.limit)

        if request.offset is not None:
            query = query.offset(request.offset)

        invites = await query.order_by(models.Invitation.created_at.desc()).gino.all()
        get_size_task = asyncio.create_task(size_query.gino.scalar())

        return structs.InviteList(
            size=await get_size_task,
            invites=[structs.Invite(
                invite_id=invite.id,
                email=invite.email,
                status=invite.status,
                created_at=invite.created_at
            ) for invite in invites]
        )
