import pytest
from crm.agency_cabinet.ord.server.src.celery.tasks.transfer.import_reports import AgencyDirectReportImporter
from crm.agency_cabinet.ord.server.src.config import MDS_SETTINGS, REPORTS_MDS_SETTINGS


@pytest.fixture
def agency_direct_report_importer(mds_cfg, fixture_celery_report_import):
    return AgencyDirectReportImporter(
        MDS_SETTINGS,
        REPORTS_MDS_SETTINGS,
        fixture_celery_report_import[0].id,
        fixture_celery_report_import[0].report_id,
        1,
        'mds_filename'
    )


@pytest.fixture()
async def fixture_celery_agency_direct_common_headers():
    return [
        'Логин/Кампания',
        'Площадка',
        'Я-Агентство',
        'Мой контрагент',
        'Договор между агентством и его контрагентом',
        'Контрагент конечного рекламодателя',
        'Конечный рекламодатель',
        'Договор между конечным рекламодателем и его исполнителем'
    ]


@pytest.fixture()
async def fixture_celery_agency_direct_headers():
    return [
        # Логин/Кампания
        'Client ID',
        'Login',
        'Рекламная кампания',
        'Рекомендуемая сумма (с НДС)',
        'Идентификатор креатива',
        # Площадка
        'Акт',
        'Сумма (с НДС)',
        'Признак "с НДС"',
        # Я-Агентство
        'ИНН',
        'Тип организации',
        'ОПФ и полное наименование',
        'Абонентский номер мобильного телефона',
        'Номер электронного средства платежа',
        'Регистрационный номер либо его аналог',
        'Номер налогоплательщика либо его аналог в стране регистрации',
        'Код страны регистрации юрлица в соответствии с ОКСМ',
        # Мой контрагент
        'ИНН',
        'Тип организации',
        'ОПФ и полное наименование',
        'Абонентский номер мобильного телефона',
        'Номер электронного средства платежа',
        'Регистрационный номер либо его аналог',
        'Номер налогоплательщика либо его аналог в стране регистрации',
        'Код страны регистрации юрлица в соответствии с ОКСМ',
        # Договор между агентством и его контрагентом
        'Номер договора',
        'Тип договора',
        'Описание осуществляемых посредником-представителем действий',
        'Сведения о предмете договора',
        'Дата договора / доп.соглашения',
        'Цена договора',
        'Признак "с НДС"',
        'Акт',
        'Сумма (с НДС)',
        'Признак "с НДС"',
        'Мой контрагент является конечным',
        # Контрагент конечного рекламодателя'
        'ИНН',
        'Тип организации',
        'ОПФ и полное наименование',
        'Абонентский номер мобильного телефона',
        'Номер электронного средства платежа',
        'Регистрационный номер либо его аналог',
        'Номер налогоплательщика либо его аналог в стране регистрации',
        'Код страны регистрации юрлица в соответствии с ОКСМ',
        # Конечный рекламодатель
        'ИНН',
        'Тип организации',
        'ОПФ и полное наименование',
        'Абонентский номер мобильного телефона',
        'Номер электронного средства платежа',
        'Регистрационный номер либо его аналог',
        'Номер налогоплательщика либо его аналог в стране регистрации',
        'Код страны регистрации юрлица в соответствии с ОКСМ',
        # Договор между конечным рекламодателем и его исполнителем
        'Номер договора',
        'Тип договора',
        'Описание осуществляемых посредником-представителем действий',
        'Сведения о предмете договора',
        'Дата договора / доп.соглашения',
        'Цена договора',
        'Признак "с НДС"',
    ]
