SELECT
ord.report.period_from AS date,
ord.report.sending_date as report_sending_date,
organization_1.inn AS ad_distributor_org_inn,
organization_1.type AS ad_distributor_org_type,
organization_1.name AS ad_distributor_org_name,
organization_1.mobile_phone AS ad_distributor_org_mobile_phone,
organization_1.epay_number AS ad_distributor_org_epay_number,
organization_1.reg_number AS ad_distributor_org_reg_number,
organization_1.alter_inn AS ad_distributor_org_alter_inn,
organization_1.oksm_number AS ad_distributor_org_oksm_number,
contract_1.contract_eid AS ad_distributor_contract_eid,
contract_1.type AS ad_distributor_contract_type,
contract_1.action_type AS ad_distributor_contract_action_type,
contract_1.subject_type AS ad_distributor_contract_subject_type,
contract_1.date AS ad_distributor_contract_date,
contract_1.amount AS ad_distributor_contract_amount,
contract_1.is_vat AS ad_distributor_contract_is_vat,
act_1.act_eid AS ad_distributor_act_eid,
act_1.amount AS ad_distributor_act_amount,
act_1.is_vat AS ad_distributor_act_is_vat,
ord.report.agency_id AS client_id,
organization_2.inn AS agency_org_inn,
organization_2.type AS agency_org_type,
organization_2.name AS agency_org_name,
organization_2.mobile_phone AS agency_org_mobile_phone,
organization_2.epay_number AS agency_org_epay_number,
organization_2.reg_number AS agency_org_reg_number,
organization_2.alter_inn AS agency_org_alter_inn,
organization_2.oksm_number AS agency_org_oksm_number,
act_2.act_eid AS agency_client_act_eid,
act_2.amount AS agency_client_act_amount,
act_2.is_vat AS agency_client_act_is_vat,
ord.client.client_id AS agency_client_id,
ord.client.login AS agency_client_login,
quote_ident(client.name) AS agency_client_name,
contract_2.contract_eid AS agency_client_contract_eid,
contract_2.type AS agency_client_contract_type,
contract_2.action_type AS agency_client_contract_action_type,
contract_2.subject_type AS agency_client_contract_subject_type,
contract_2.date AS agency_client_contract_date,
contract_2.amount AS agency_client_contract_amount,
contract_2.is_vat AS partner_contract_is_vat,
organization_3.inn AS agency_client_org_inn,
organization_3.type AS agency_client_org_type,
organization_3.name AS agency_client_org_name,
organization_3.mobile_phone AS agency_client_org_mobile_phone,
organization_3.epay_number AS agency_client_org_epay_number,
organization_3.reg_number AS agency_client_org_reg_number,
organization_3.alter_inn AS agency_client_org_alter_inn,
organization_3.oksm_number AS agency_client_org_oksm_number,
contract_3.contract_eid AS advertiser_contract_eid,
contract_3.type AS advertiser_contract_type,
contract_3.action_type AS advertiser_contract_action_type,
contract_3.subject_type AS advertiser_contract_subject_type,
contract_3.date AS advertiser_contract_date,
contract_3.amount AS advertiser_contract_amount,
contract_3.is_vat AS advertiser_contract_is_vat,
organization_4.inn AS advertiser_contractor_organization_inn,
organization_4.type AS advertiser_contractor_organization_type,
organization_4.is_ors AS advertiser_contractor_organization_is_ors,
organization_4.is_rr AS advertiser_contractor_organization_is_rr,
organization_4.name AS advertiser_contractor_organization_name,
organization_4.mobile_phone AS advertiser_contractor_organization_mobile_phone,
organization_4.epay_number AS advertiser_contractor_organization_epay_number,
organization_4.reg_number AS advertiser_contractor_organization_reg_number,
organization_4.alter_inn AS advertiser_contractor_organization_alter_inn,
organization_4.oksm_number AS advertiser_contractor_organization_oksm_number,
organization_5.inn AS advertiser_organization_inn,
organization_5.type AS advertiser_org_type,
organization_5.is_ors AS advertiser_org_is_ors,
organization_5.is_rr AS advertiser_org_is_rr,
organization_5.name AS advertiser_org_name,
organization_5.mobile_phone AS advertiser_org_mobile_phone,
organization_5.epay_number AS advertiser_org_epay_number,
organization_5.reg_number AS advertiser_org_reg_number,
organization_5.alter_inn AS advertiser_org_alter_inn,
organization_5.oksm_number AS advertiser_org_oksm_number,
ord.campaign.campaign_eid AS campaign_eid,
quote_ident(ord.campaign.name) AS campaign_name
FROM ord.client_row
JOIN ord.client ON ord.client.id = ord.client_row.client_id
JOIN ord.report on ord.report.id = ord.client.report_id
LEFT OUTER JOIN ord.campaign ON ord.client_row.campaign_id = ord.campaign.id
LEFT OUTER JOIN ord.contract AS contract_1 ON ord.client_row.ad_distributor_contract_id = contract_1.id
LEFT OUTER JOIN ord.organization AS organization_1 ON contract_1.contractor_id = organization_1.id
LEFT OUTER JOIN ord.organization AS organization_2 ON contract_1.client_id = organization_2.id
LEFT OUTER JOIN ord.act AS act_1 ON ord.client_row.ad_distributor_act_id = act_1.id
LEFT OUTER JOIN ord.contract AS contract_2 ON ord.client_row.partner_contract_id = contract_2.id
LEFT OUTER JOIN ord.organization AS organization_3 ON contract_2.client_id = organization_3.id
LEFT OUTER JOIN ord.act AS act_2 ON ord.client_row.partner_act_id = act_2.id
LEFT OUTER JOIN ord.contract AS contract_3 ON ord.client_row.advertiser_contract_id = contract_3.id
LEFT OUTER JOIN ord.organization AS organization_5 ON contract_3.client_id = organization_5.id
LEFT OUTER JOIN ord.organization AS organization_4 ON contract_3.contractor_id = organization_4.id
