PY3TEST()

OWNER(g:agency_cabinet_back)

INCLUDE(${ARCADIA_ROOT}/crm/agency_cabinet/common/testing/recipes/postgresql/postgresql.inc)

DEPENDS(
    antiadblock/postgres_local/recipe
    crm/agency_cabinet/ord/server/migrations
)

SIZE(MEDIUM)

PEERDIR(
    contrib/python/asynctest
    contrib/python/pytest-asyncio
    contrib/python/openpyxl
    crm/agency_cabinet/ord/common
    crm/agency_cabinet/ord/server
    crm/agency_cabinet/common/testing
    crm/agency_cabinet/common/service_discovery
)

PY_SRCS(
    celery/conftest.py
    celery/import_reports/agency_direct/conftest.py
    celery/import_reports/agency_direct/base.py
    handlers/conftest.py
    procedures/client_rows/conftest.py
    procedures/conftest.py
    conftest.py
)

TEST_SRCS(
    nirvana_scripts/test_upload_to_yt_query.py

    celery/export_reports/test_agency_direct.py
    celery/export_reports/test_base.py

    celery/import_reports/agency_direct/test_agency_direct_same_rows.py
    celery/import_reports/agency_direct/test_agency_direct_update_rows.py
    celery/import_reports/agency_direct/test_agency_direct_replace_rows.py
    celery/import_reports/agency_direct/test_agency_direct_wrong_rows.py
    celery/import_reports/agency_direct/test_agency_direct_wrong_headers.py
    celery/import_reports/test_base.py

    celery/load_reports/test_synchronizer.py

    handlers/acts/test_get_acts.py
    handlers/acts/test_add_act.py
    handlers/acts/test_edit_act.py
    handlers/client_rows/test_edit_client_row.py
    handlers/client_rows/test_get_client_rows.py
    handlers/clients/test_get_clients.py
    handlers/clients/test_create_client.py
    handlers/clients/test_get_client_short_info.py
    handlers/invites/test_get_invites.py
    handlers/organizations/test_get_organizations.py
    handlers/test_create_report.py
    handlers/test_delete_report.py
    handlers/test_get_lock_status.py
    handlers/test_get_ord_reports.py
    handlers/test_import_data.py
    handlers/test_send_report.py
    handlers/test_get_report_url.py
    handlers/test_export_report.py
    handlers/test_get_report_export_info.py
    handlers/test_get_campaigns.py
    handlers/contracts/test_get_contracts.py

    procedures/acts/test_get_acts.py
    procedures/acts/test_add_act.py
    procedures/acts/test_edit_act.py
    procedures/client_rows/test_edit_client_row.py
    procedures/client_rows/test_get_client_rows.py
    procedures/clients/test_create_client.py
    procedures/clients/test_get_client_short_info.py
    procedures/clients/test_get_clients_list.py
    procedures/invites/test_get_invites.py
    procedures/organizations/test_get_organizations.py
    procedures/reports/test_create_report.py
    procedures/reports/test_get_reports.py
    procedures/test_delete_report.py
    procedures/test_get_lock_status.py
    procedures/test_get_report_url.py
    procedures/test_export_report.py
    procedures/test_get_export_report_info.py
    procedures/test_import_data.py
    procedures/test_get_campaigns.py
    procedures/test_get_contracts.py
)


RESOURCE(
    crm/agency_cabinet/ord/server/tests/nirvana_scripts/upload_to_yt_query.sql query
)

IF(NOT OS_DARWIN)
    FORK_TEST_FILES()
ENDIF()

END()
