PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)

PEERDIR(
    contrib/python/alembic
    contrib/python/ipython
    contrib/python/openpyxl

    crm/agency_cabinet/common/celery
    crm/agency_cabinet/common/config
    crm/agency_cabinet/common/db
    crm/agency_cabinet/common/definitions
    crm/agency_cabinet/common/monitoring
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/common/server/rpc
    crm/agency_cabinet/common/yql
    crm/agency_cabinet/common/yt

    crm/agency_cabinet/ord/common
    crm/agency_cabinet/ord/proto
)

PY_SRCS(
    src/celery/__init__.py
    src/celery/base.py
    src/celery/tasks/__init__.py
    src/celery/tasks/export_report_experiment.py
    src/celery/tasks/load_client_info.py
    src/celery/tasks/transfer/export_reports/agency_direct.py
    src/celery/tasks/transfer/export_reports/base.py
    src/celery/tasks/transfer/export_reports/__init__.py
    src/celery/tasks/transfer/import_reports/agency_direct.py
    src/celery/tasks/transfer/import_reports/base.py
    src/celery/tasks/transfer/import_reports/__init__.py
    src/celery/tasks/transfer/format.py
    src/celery/tasks/load_reports/__init__.py
    src/celery/tasks/load_reports/loader.py
    src/celery/tasks/load_reports/synchronizer.py

    src/db/models/__init__.py
    src/db/models/act.py
    src/db/models/campaign.py
    src/db/models/contract.py
    src/db/models/client.py
    src/db/models/invitation.py
    src/db/models/mds.py
    src/db/models/organization.py
    src/db/models/report.py
    src/db/models/report_import.py
    src/db/models/report_export.py
    src/db/models/report_settings.py
    src/db/__init__.py
    src/db/engine.py
    src/db/queries.py

    src/procedures/__init__.py
    src/procedures/act.py
    src/procedures/campaigns.py
    src/procedures/common.py
    src/procedures/client_rows.py
    src/procedures/clients.py
    src/procedures/import_data.py
    src/procedures/invites.py
    src/procedures/organizations.py
    src/procedures/reports.py
    src/procedures/contracts.py

    src/__init__.py
    src/config.py
    src/handler.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(
    bin
    migrations
)
