from marshmallow import Schema, fields, post_dump


class CalculatorDataClientGradeSchema(Schema):
    grade_id = fields.String(required=True)
    domains_count = fields.Int()
    revenue_average = fields.Float()
    revenue = fields.Float()

    @post_dump
    def clean_missing(self, data, *args, **kwargs):
        ret = data.copy()
        for key in filter(lambda key: data[key] is None, data):
            del ret[key]
        return ret


class CalculatorDataIndexSchema(Schema):
    index_id = fields.String(required=True)
    revenue = fields.Float(required=True)


class CalculatorDataMonthSchema(Schema):
    grades = fields.List(fields.Nested(CalculatorDataClientGradeSchema))
    indexes = fields.List(fields.Nested(CalculatorDataIndexSchema))
    predict = fields.Boolean(required=True)
    period_from = fields.DateTime(required=True)


class CalculatorDataSchema(Schema):
    months = fields.List(fields.Nested(CalculatorDataMonthSchema))
