from marshmallow import Schema, fields


class CalculatorMetaClientGradeSchema(Schema):
    grade_id = fields.String(required=True)
    threshold_start = fields.Float()
    threshold_end = fields.Float(allow_none=True, default=None)
    reward_percent = fields.Float(required=True)
    reward_fix = fields.Int()


class CalculatorMetaIndexGradeSchema(Schema):
    threshold_start = fields.Float()
    threshold_end = fields.Float(allow_none=True)
    reward_percent = fields.Float(required=True)


class CalculatorMetaIndexWithGradeSchema(Schema):
    index_id = fields.String(required=True)
    grades = fields.List(fields.Nested(CalculatorMetaIndexGradeSchema))


# TODO remove
class CalculatorMetaIndexRewardPercentSchema(Schema):
    period_from = fields.DateTime(required=True)
    reward_percent = fields.Float(required=True)


class CalculatorMetaIndexSchema(Schema):
    index_id = fields.String(required=True)
    reward_percent = fields.Float()
    reward_percent_by_period = fields.List(fields.Nested(CalculatorMetaIndexRewardPercentSchema))  # TODO remove


class CalculatorMetaMonthSchema(Schema):
    grades = fields.List(fields.Nested(CalculatorMetaClientGradeSchema))
    indexes = fields.List(fields.Nested(CalculatorMetaIndexSchema))


class CalculatorMetaConcreteMonthSchema(CalculatorMetaMonthSchema):
    period_from = fields.DateTime()


class CalculatorMetaQuarterSchema(Schema):
    indexes = fields.List(fields.Nested(CalculatorMetaIndexSchema))
    indexes_with_grade = fields.List(fields.Nested(CalculatorMetaIndexWithGradeSchema))


class CalculatorMetaConcreteQuarterSchema(CalculatorMetaQuarterSchema):
    period_from = fields.DateTime()


class CalculatorMetaSemiyearSchema(Schema):
    indexes = fields.List(fields.Nested(CalculatorMetaIndexSchema))
    indexes_with_grade = fields.List(fields.Nested(CalculatorMetaIndexWithGradeSchema))


class CalculatorMetaConcreteSemiyearSchema(Schema):
    period_from = fields.DateTime()


class CalculatorMetaSchema(Schema):
    month = fields.Nested(CalculatorMetaMonthSchema)
    quarter = fields.Nested(CalculatorMetaQuarterSchema)
    semiyear = fields.Nested(CalculatorMetaSemiyearSchema)

    months = fields.List(fields.Nested(CalculatorMetaConcreteMonthSchema))
    quarters = fields.List(fields.Nested(CalculatorMetaConcreteQuarterSchema))
    semiyears = fields.List(fields.Nested(CalculatorMetaConcreteSemiyearSchema))
