from smb.common.helpers import Converter

from crm.agency_cabinet.common.consts import ContractType, Services, CalculatorServiceType
from crm.agency_cabinet.rewards.proto import common_pb2

contract_type_converter = Converter(
    [
        (common_pb2.ContractType.unknown, ContractType.unknown),
        (common_pb2.ContractType.base, ContractType.base),
        (common_pb2.ContractType.prof, ContractType.prof),
        (common_pb2.ContractType.aggregator, ContractType.aggregator),
    ]
)

service_type_converter = Converter(
    [
        (common_pb2.Services.media, Services.media),
        (common_pb2.Services.direct, Services.direct),
        (common_pb2.Services.zen, Services.zen),
        (common_pb2.Services.video, Services.video),
        (common_pb2.Services.sprav, Services.sprav),
        (common_pb2.Services.business, Services.business),
        (common_pb2.Services.early_payment, Services.early_payment),
        (common_pb2.Services.unknown_service, None),
    ]
)  # TODO: move to common for all microservices?


calculator_service_type_converter = Converter(
    [
        (common_pb2.CalculatorServicesType.calc_media, CalculatorServiceType.media),
        (common_pb2.CalculatorServicesType.calc_direct, CalculatorServiceType.direct),
        (common_pb2.CalculatorServicesType.calc_zen, CalculatorServiceType.zen),
        (common_pb2.CalculatorServicesType.calc_video, CalculatorServiceType.video),
        (common_pb2.CalculatorServicesType.calc_business, CalculatorServiceType.business),
        (common_pb2.CalculatorServicesType.calc_aggregator, CalculatorServiceType.aggregator),
        (common_pb2.CalculatorServicesType.calc_unknown_service, None),
    ]
)
