from dataclasses import dataclass

from crm.agency_cabinet.common.proto_utils import BaseStruct
from crm.agency_cabinet.rewards.proto import documents_pb2


@dataclass
class GetDocumentUrlRequest(BaseStruct):
    agency_id: int
    document_id: int

    @classmethod
    def from_proto(cls, message: documents_pb2.GetDocumentUrl) -> 'GetDocumentUrlRequest':
        return cls(agency_id=message.agency_id, document_id=message.document_id)


@dataclass
class GetDocumentUrlResponse(BaseStruct):
    document_url: str

    @classmethod
    def from_proto(cls, message: documents_pb2.DocumentUrl) -> 'GetDocumentUrlResponse':
        return cls(document_url=message.url)

    def to_proto(self) -> documents_pb2.DocumentUrl:
        return documents_pb2.DocumentUrl(url=self.document_url)
