from datetime import datetime

from crm.agency_cabinet.common.consts import RewardsTypes


def get_reward_index(start_fin_year: datetime, period_from: datetime, reward_type: str) -> int:
    month_delta = (period_from.year - start_fin_year.year) * 12 + period_from.month - start_fin_year.month
    if reward_type == RewardsTypes.month.value:
        return month_delta
    elif reward_type == RewardsTypes.quarter.value:
        return month_delta // 3
    else:
        return month_delta // 6
