import crm.agency_cabinet.common.monitoring.clusters as clusters
from functools import cache
from library.python.monitoring.solo.objects.solomon.sensor import Sensor
from library.python.monitoring.solo.objects.solomon.v2 import Cluster
from crm.agency_cabinet.common.monitoring.project import agency_cabinet_solomon_project as project
from crm.agency_cabinet.common.monitoring.sensors import get_service_uptime
from crm.agency_cabinet.rewards.monitoring.registry.service import rewards


testing_rewards_uptime = get_service_uptime(clusters.testing, rewards)
prestable_rewards_uptime = get_service_uptime(clusters.prestable, rewards)
prod_rewards_uptime = get_service_uptime(clusters.prod, rewards)


@cache
def get_rewards_error_reports(cluster: Cluster):
    return Sensor(
        project=project.id,
        cluster=cluster.name,
        service=rewards.name,
        sensor='rewards.error_reports'
    )


@cache
def build_metrics():
    metrics_list = [testing_rewards_uptime, prestable_rewards_uptime, prod_rewards_uptime]
    for cluster in clusters.register:
        metrics_list.append(get_rewards_error_reports(cluster))
    return metrics_list


REWARDS_UPTIME_METRIC = {
    clusters.testing: testing_rewards_uptime,
    clusters.prestable: prestable_rewards_uptime,
    clusters.prod: prestable_rewards_uptime
}

register = build_metrics()
