import click

from crm.agency_cabinet.rewards.server.src import run_server as _run_server
from crm.agency_cabinet.rewards.server.src.celery import celery


@click.group()
def cli():
    pass


@cli.command('run_server')
def run_server():
    return _run_server()


@cli.command('celery_beat', context_settings=dict(
    ignore_unknown_options=True,
))
@click.argument('celery_beat_args', nargs=-1, type=click.UNPROCESSED)
def celery_beat(celery_beat_args):
    return celery.start(['beat'] + list(celery_beat_args))


@cli.command('celery_worker', context_settings=dict(
    ignore_unknown_options=True,
))
@click.argument('celery_worker_args', nargs=-1, type=click.UNPROCESSED)
def celery_worker(celery_worker_args):
    return celery.worker_main(argv=['worker'] + list(celery_worker_args))


@cli.command('celery', context_settings=dict(
    ignore_unknown_options=True,
))
@click.argument('celery_cli_args', nargs=-1, type=click.UNPROCESSED)
def celery_cli(celery_cli_args):
    if celery_cli_args and celery_cli_args[0] == 'tasks':
        for task_name in celery.tasks.keys():
            print(task_name)
        return
    return celery.start(argv=['call'] + list(celery_cli_args))


@cli.command('shell')
def shell():
    from IPython import embed
    embed()


def main():
    cli()


if __name__ == '__main__':
    main()
