from celery.schedules import crontab
from environs import Env

from .sqs import SQS_ENDPOINT

env = Env()

CELERY_SETTINGS = {
    'broker_url': SQS_ENDPOINT if env.bool('USE_SQS', True) else env('BROKER_URL', 'redis://localhost:6379'),
    'result_expires': None,  # despite we don't use result_backend (i.e. DisabledBackend), celery beat generates
    'task_routes': {              # task to clean up dummy backend; remove if/when we use result_backend
        'crm.agency_cabinet.rewards.server.src.celery.tasks.*': {
            'queue': 'rewards'
        }
    },
    'imports': ['crm.agency_cabinet.common.celery.signals', 'crm.agency_cabinet.rewards.server.src.celery.tasks'],
    'beat_schedule': {
        # 'load_month_rewards_from_yt': {
        #    'task': 'crm.agency_cabinet.rewards.server.src.celery.tasks.'
        #            'load_rewards.load_month_rewards_tables_from_yt_task',
        #    'schedule': env.float(
        #        'CHECK_YT_INTERVAL',
        #        10),  # for testing purposes only; need to change default interval
        #    'options': {
        #        'queue': 'rewards'
        #    },
        # },
        'generate_reports': {
            'task': 'crm.agency_cabinet.rewards.server.src.celery.tasks.reports.generate_report.check_requested_reports_task',
            'schedule': env.float('CHECK_REPORTS_INTERVAL', 30),  # Проверяем отчеты каждые 30 сек, на проде можно чаще
            'options': {
                'queue': 'rewards'
            },
        },
        'load_documents': {
            'task': 'crm.agency_cabinet.rewards.server.src.celery.tasks.documents.load_documents.load_documents_info_task',
            'schedule': crontab(hour='1', minute='17'),  # UTC
            'options': {
                'queue': 'rewards'
            }
        },
        'load_yadoc_ids': {
            'task': 'crm.agency_cabinet.rewards.server.src.celery.tasks.documents.load_yadoc_ids.load_yadoc_ids_task',
            'schedule': crontab(hour='2', minute='03'),  # UTC
            'options': {
                'queue': 'rewards'
            }
        },
        'clear_faulty_in_progress_reports_task': {
            'task': 'crm.agency_cabinet.rewards.server.src.celery.tasks.reports.check_report_statuses.clear_faulty_in_progress_reports_task',
            'schedule': env.float('CLEAR_REPORTS_INTERVAL', 60 * 30),
            'options': {
                'queue': 'rewards_utils',
            },
            'kwargs': {
                'delta_hours': env.int('CHECK_IN_PROGRESS_REPORTS_DELTA_HOURS', 1)
            }
        },
        'clear_old_error_reports_task': {
            'task': 'crm.agency_cabinet.rewards.server.src.celery.tasks.reports.check_report_statuses.clear_old_error_reports_task',
            'schedule': env.float('CLEAR_REPORTS_INTERVAL', 60 * 30),
            'options': {
                'queue': 'rewards_utils',
            },
            'kwargs': {
                'delta_hours': env.int('CHECK_ERROR_REPORTS_DELTA_HOURS', 24 * 3)
            }
        },
        'load_contracts_info': {
            'task': 'crm.agency_cabinet.rewards.server.src.celery.tasks.contracts.load_contracts_info.load_contracts_info_task',
            'schedule': crontab(day_of_month=1, hour=3, minute=45),  # UTC
            'options': {
                'queue': 'rewards'
            }
        },
    },  # TODO: use better name and structure for tasks
    'beat_scheduler': 'crm.agency_cabinet.common.celery.scheduler.LockedPersistentScheduler',
    'broker_transport_options': {
        'is_secure': False,
        'region': 'yandex',
    }
}
