# -*- coding: utf-8 -*-
from environs import Env
from gino.dialects.asyncpg import Pyscopg2Pool
from sqlalchemy.engine.url import URL

env = Env()

DATABASE_SETTINGS = {
    'dsn': URL(
        drivername='postgresql',
        username=env('PG_LOCAL_USER', 'postgres'),
        password=env('PG_LOCAL_PASSWORD', 'postgres'),
        host=env('PG_LOCAL_HOST', 'localhost'),
        port=env.int('PG_LOCAL_PORT', 5432),
        database=env('PG_LOCAL_DATABASE', 'postgres'),
    ),
    'ssl': env('PG_SSL', 'verify-full'),
    'pool_class': Pyscopg2Pool
}

GINO_METADATA_SETTINGS = {
    'naming_convention': {
        'ix': '%(table_name)__%(column_0_name)s__idx',
        'uq': '%(table_name)s__%(column_0_name)s__uq',
        'ck': '%(table_name)s__%(constraint_name)s__ck',
        'fk': '%(table_name)s_%(referred_table_name)s__%(column_0_name)s__fk',
        'pk': '%(table_name)s__pk'
    },
    'schema': 'rewards'
}
