# -*- coding: utf-8 -*-
import os
import sys
from alembic.config import CommandLine, Config
from library.python import resource

import crm.agency_cabinet.rewards.server.config as config
from crm.agency_cabinet.rewards.server.migrations.settings import RESOURCES_PATH_PREFIX, SCRIPT_LOCATION


def extract_resources():
    for res, data in resource.iteritems(prefix='resfs/file/{}'.format(RESOURCES_PATH_PREFIX), strip_prefix=True):  # noqa
        path = os.path.join(SCRIPT_LOCATION, res)

        if not os.path.exists(path):
            parent = os.path.normpath(os.path.join(path, os.pardir))
            if not os.path.exists(parent):
                os.makedirs(parent)
            with open(path, 'wb') as f:
                f.write(data)


def main():
    extract_resources()

    cl = CommandLine()
    options = cl.parser.parse_args(sys.argv[1:])

    cfg = Config(
        file_='{}/alembic.ini'.format(SCRIPT_LOCATION),
        ini_section=options.name,
        cmd_opts=options,
    )

    cfg.set_main_option('script_location', SCRIPT_LOCATION)
    cfg.set_main_option('version_locations', '{}/versions'.format(SCRIPT_LOCATION))

    url = "postgresql+psycopg2://{user}:{password}@/{dbname}?host={host}&port={port}&" \
          "target_session_attrs=read-write".format(user=config.DATABASE_SETTINGS['dsn'].username,
                                                    password=config.DATABASE_SETTINGS['dsn'].password,
                                                    dbname=config.DATABASE_SETTINGS['dsn'].database,
                                                    host=config.DATABASE_SETTINGS['dsn'].host,
                                                    port=config.DATABASE_SETTINGS['dsn'].port)
    cfg.set_main_option('sqlalchemy.url', url)
    sys.exit(cl.run_cmd(cfg, options))


if __name__ == '__main__':
    main()
