"""init

Revision ID: 9ec627713f3a
Revises: 9f70ec52d2ad
Create Date: 2021-07-02 17:23:59.671286

"""
from alembic import op
import sqlalchemy as sa
import yenv


# revision identifiers, used by Alembic.
revision = '9ec627713f3a'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('CREATE SCHEMA IF NOT EXISTS rewards')
    op.create_table('contract',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('eid', sa.Text(), nullable=False),
                    sa.Column('agency_id', sa.BigInteger(), nullable=False),
                    sa.Column('payment_type', sa.Text(), nullable=False),
                    sa.Column('type', sa.Text(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('contract__pk')),
                    sa.UniqueConstraint('eid', name=op.f('contract__eid__uq')),
                    schema='rewards'
                    )
    op.create_index('contract__agency_id_idx', 'contract', ['agency_id'], unique=False, schema='rewards')
    op.create_index('contract__eid_idx', 'contract', ['eid'], unique=True, schema='rewards')
    op.create_table('tools_yt_sync',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('path', sa.Text(), nullable=True),
                    sa.Column('last_used_update', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('enabled', sa.Boolean(), server_default='t', nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('tools_yt_sync__pk')),
                    sa.UniqueConstraint('path', name=op.f('tools_yt_sync__path__uq')),
                    schema='rewards'
                    )
    op.create_index('tools_yt_sync__path__idx', 'tools_yt_sync', ['path'], unique=False, schema='rewards')
    op.create_table('reward',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('contract_id', sa.BigInteger(), nullable=False),
                    sa.Column('type', sa.Text(), nullable=False),
                    sa.Column('got_scan', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('got_original', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('is_paid', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('is_accrued', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('is_prof', sa.Boolean(), nullable=False),
                    sa.Column('payment', sa.Integer(), nullable=True),
                    sa.Column('payment_date', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('period_from', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['contract_id'], ['rewards.contract.id'], name=op.f('reward_contract__contract_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('reward__pk')),
                    schema='rewards'
                    )
    op.create_table('service_reward',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('reward_id', sa.BigInteger(), nullable=False),
                    sa.Column('service', sa.Text(), nullable=False),
                    sa.Column('discount_type', sa.Integer(), nullable=False),
                    sa.Column('payment', sa.Integer(), nullable=True),
                    sa.Column('revenue', sa.Integer(), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['reward_id'], ['rewards.reward.id'], name=op.f('service_reward_reward__reward_id__fk'), ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id', name=op.f('service_reward__pk')),
                    schema='rewards'
                    )
    op.create_table('condition',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('service_reward_id', sa.BigInteger(), nullable=False),
                    sa.Column('message', sa.Text(), nullable=False),
                    sa.Column('status', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['service_reward_id'], ['rewards.service_reward.id'], name=op.f('condition_service_reward__service_reward_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('condition__pk')),
                    schema='rewards'
                    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('condition', schema='rewards')
    op.drop_table('service_reward', schema='rewards')
    op.drop_table('reward', schema='rewards')
    op.drop_index('tools_yt_sync__path__idx', table_name='tools_yt_sync', schema='rewards')
    op.drop_table('tools_yt_sync', schema='rewards')
    op.drop_index('contract__eid_idx', table_name='contract', schema='rewards')
    op.drop_index('contract__agency_id_idx', table_name='contract', schema='rewards')
    op.drop_table('contract', schema='rewards')
    op.execute('DROP SCHEMA IF EXISTS rewards')
    # ### end Alembic commands ###
