"""empty message

Revision ID: 60ead33816d4
Revises: f7e96c973f5f
Create Date: 2021-08-13 15:03:53.656988

"""
from alembic import op
import sqlalchemy as sa
import yenv

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '60ead33816d4'
down_revision = 'f7e96c973f5f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('calculator_data',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('contract_id', sa.BigInteger(), nullable=False),
                    sa.Column('service', sa.String(), nullable=False),
                    sa.Column('data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['contract_id'], ['rewards.contract.id'], name=op.f('calculator_data_contract__contract_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('calculator_data__pk')),
                    sa.UniqueConstraint('contract_id', 'service', name='calculator_data__contract_id_service__uc'),
                    schema='rewards'
                    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('calculator_data', schema='rewards')
    # ### end Alembic commands ###
