"""reports

Revision ID: c58526f270ec
Revises: 60ead33816d4
Create Date: 2021-08-24 17:44:06.167433

"""
from alembic import op
import sqlalchemy as sa
import yenv

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'c58526f270ec'
down_revision = '60ead33816d4'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('report_meta_info',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('name', sa.Text(), nullable=False),
                    sa.Column('contract_id', sa.BigInteger(), nullable=False),
                    sa.Column('type', sa.Text(), nullable=False),
                    sa.Column('service', sa.Text(), nullable=False),
                    sa.Column('period_from', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('period_to', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('clients_ids', postgresql.ARRAY(sa.BigInteger()), nullable=True),
                    sa.Column('status', sa.Text(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['contract_id'], ['rewards.contract.id'], name=op.f('report_meta_info_contract__contract_id__fk'), ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id', name=op.f('report_meta_info__pk')),
                    schema='rewards'
                    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('report_meta_info', schema='rewards')
    # ### end Alembic commands ###
