"""s3_mds_file

Revision ID: 755e3b23a093
Revises: 217b81f9a6f7
Create Date: 2021-09-06 17:45:54.000780

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '755e3b23a093'
down_revision = '217b81f9a6f7'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('s3_mds_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('bucket', sa.Text(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('display_name', sa.Text(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('s3_mds_file__pk')),
    schema='rewards'
    )
    op.add_column('report_meta_info', sa.Column('file_id', sa.BigInteger(), nullable=True), schema='rewards')
    op.create_foreign_key(op.f('report_meta_info_s3_mds_file__file_id__fk'), 'report_meta_info', 's3_mds_file', ['file_id'], ['id'], source_schema='rewards', referent_schema='rewards', ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('report_meta_info_contract__file_id__fk'), 'report_meta_info', schema='rewards', type_='foreignkey')
    op.drop_column('report_meta_info', 'file_id', schema='rewards')
    op.drop_table('s3_mds_file', schema='rewards')
    # ### end Alembic commands ###
