"""empty message

Revision ID: 5a14bdae5ee1
Revises: 755e3b23a093
Create Date: 2021-09-13 20:14:19.226795

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '5a14bdae5ee1'
down_revision = '60e11fc7c9b5'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('document',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('reward_id', sa.BigInteger(), nullable=False),
                    sa.Column('yadoc_id', sa.BigInteger(), nullable=False),
                    sa.Column('name', sa.String(), nullable=False),
                    sa.Column('type', sa.String(), nullable=False),
                    sa.Column('sending_date', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('got_scan', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('got_original', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['reward_id'], ['rewards.reward.id'], name=op.f('document_reward__reward_id__fk'), ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id', name=op.f('document__pk')),
                    schema='rewards'
                    )

    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('document', schema='rewards')
    # ### end Alembic commands ###
