"""service_rewards_constraints

Revision ID: 62d0107dad0a
Revises: 58dfc40a60ea
Create Date: 2021-09-21 02:05:35.794181

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '62d0107dad0a'
down_revision = '58dfc40a60ea'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_check_constraint(
        op.f('service_reward__validate_services__ck'),
        'service_reward',
        'service in (\'media\', \'direct\', \'zen\', \'video\', \'sprav\', \'business\', \'early_payment\')',
        schema='rewards'
    )
    op.create_unique_constraint(
        op.f('service_reward__reward_id__uq'),
        'service_reward',
        ['reward_id', 'discount_type', 'service'],
        schema='rewards'
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('service_reward__validate_services__ck'), 'service_reward', schema='rewards', type_='check')
    op.drop_constraint(op.f('service_reward__reward_id__uq'), 'service_reward', schema='rewards', type_='unique')
    # ### end Alembic commands ###
