import asyncio
import logging.config
from crm.agency_cabinet.common.server.common.logging_config import get_logging_config
from crm.agency_cabinet.common.server.rpc.config import RpcServerConfig
from crm.agency_cabinet.rewards.server.config.tvm import RewardsTvm2Config  # noqa TODO: use one type of config everwhere
from crm.agency_cabinet.common.service_discovery import ServiceDiscovery
from crm.agency_cabinet.rewards.common import QUEUE
from crm.agency_cabinet.rewards.server.config.db import DATABASE_SETTINGS
from crm.agency_cabinet.rewards.server.config.mds import MDS_SETTINGS
from crm.agency_cabinet.rewards.server.config.clients import YADOC_CONFIG
from crm.agency_cabinet.rewards.server.src.db import db
from crm.agency_cabinet.rewards.server.src.handler import Handler
from crm.agency_cabinet.common.monitoring.utils.server import run_ping_service
from crm.agency_cabinet.common.monitoring.utils.registry import setup_monitoring
from crm.agency_cabinet.rewards.server.src.monitoring import RewardsMetricsHandler


__all__ = ['run_server']


def run_server():
    cfg = RpcServerConfig.from_environ()
    logging.config.dictConfig(get_logging_config(cfg.verbose))

    asyncio.run(_run_server(cfg))


async def _run_server(cfg: RpcServerConfig):
    # TODO: move to common library?
    await db.set_bind(bind=DATABASE_SETTINGS['dsn'], ssl=DATABASE_SETTINGS['ssl'], pool_class=DATABASE_SETTINGS['pool_class'])
    metric_registry = setup_monitoring()
    async with ServiceDiscovery(cfg.amqp_url, with_rpc_client=False) as sd:  # type: ServiceDiscovery
        tvm2_config = RewardsTvm2Config.from_environ()  # TODO: use one type for config
        handler = Handler(
            MDS_SETTINGS['access_key_id'],
            MDS_SETTINGS['secret_access_key'],
            MDS_SETTINGS['endpoint_url_with_auth'],
            YADOC_CONFIG['endpoint_url'],
            YADOC_CONFIG['tvm_id'],
            tvm_config=tvm2_config,
            metric_registry=metric_registry
        )
        try:
            async with sd.rpc_server(QUEUE) as server:
                await handler.setup()
                await asyncio.gather(server.drain(handler), run_ping_service(
                    metric_registry,
                    RewardsMetricsHandler,
                    metric_handler_args=(db,)
                ))
        except Exception:
            await handler.teardown()
