from crm.agency_cabinet.common.celery.base import ContextTask, BotoSessionBoundedMixin, CeleryAppFactoryContextTask
from crm.agency_cabinet.rewards.server.config.celery_settings import CELERY_SETTINGS
from crm.agency_cabinet.rewards.server.config.db import DATABASE_SETTINGS
from crm.agency_cabinet.rewards.server.config.lock import SCHEDULER_LOCK_SETTINGS
from crm.agency_cabinet.rewards.server.config.mds import MDS_SETTINGS
from crm.agency_cabinet.rewards.server.src.db import db


class RewardsContextTask(ContextTask):
    pass


class RewardsContextBoto3Task(RewardsContextTask, BotoSessionBoundedMixin):
    pass


class RewardsCeleryAppFactory(CeleryAppFactoryContextTask):
    def post_create(self, *args, **kwargs):
        super(RewardsCeleryAppFactory, self).post_create(*args, **kwargs)
        RewardsContextBoto3Task.init_mds_params(
            MDS_SETTINGS['access_key_id'],
            MDS_SETTINGS['secret_access_key'],
            MDS_SETTINGS['endpoint_url'])


celery_app = RewardsCeleryAppFactory('rewards_tasks',
                                     scheduler_lock_settings=SCHEDULER_LOCK_SETTINGS,
                                     celery_settings=CELERY_SETTINGS,
                                     task_class=RewardsContextTask,
                                     db=db,
                                     db_config=DATABASE_SETTINGS).create()
