from crm.agency_cabinet.common.consts import ContractType, CalculatorServiceType
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.actual.synchronizer import BaseBusinessActualDataSynchronizer


class AggregatorBusinessActualDataSynchronizer(BaseBusinessActualDataSynchronizer):
    service = CalculatorServiceType.business.value
    contract_type = ContractType.aggregator.value

    GRADE_META_INFO = {
        'D': {
            'threshold_start': 0
        },
        'C': {
            'threshold_start': 3500
        },
        'B': {
            'threshold_start': 20000
        },
        'A': {
            'threshold_start': 65000
        },
    }
