from .synchronizer import BaseBusinessActualDataSynchronizer, BaseDirectActualDataSynchronizer, \
    BaseZenActualDataSynchronizer, BaseMediaActualDataSynchronizer, BaseVideoActualDataSynchronizer
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.actual.loader import BaseActualDataLoader,\
    BaseActualDataWithEarlyPaymentLoader


class BaseBusinessActualDataLoader(BaseActualDataLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_m_amt_base_yab_a_65k` AS predict_business_grade_a,
        `predict_m_amt_base_yab_b_20k_65k` as predict_business_grade_b,
        `predict_m_amt_base_yab_c_4000_20k` as predict_business_grade_c,
        `predict_m_amt_base_yab_d_4000` as predict_business_grade_d
    '''
    service_name = 'Справочник'
    synchronizer_class = BaseBusinessActualDataSynchronizer


class BaseDirectActualDataLoader(BaseActualDataWithEarlyPaymentLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_amt` AS  revenue,
        `early_payments.early_payment` AS early_payment,
        `predict_m_amt_rsya` as predict_m_amt_rsya,
        `predict_q_amt_auto_Q3` as predict_q_amt_auto_Q3,
        `predict_q_amt_goal_Q3` as predict_q_amt_goal_Q3,
        `predict_q_amt_metrika` as predict_q_amt_metrika,
        `predict_q_amt_retargeting` as predict_q_amt_retargeting

    '''
    service_name = 'Директ'
    synchronizer_class = BaseDirectActualDataSynchronizer


class BaseZenActualDataLoader(BaseActualDataLoader):
    service_name = 'Дзен'
    synchronizer_class = BaseZenActualDataSynchronizer


class BaseVideoActualDataLoader(BaseActualDataWithEarlyPaymentLoader):
    COLUMNS = '''
        `dt` AS dt,
        `rewards.predict_amt` AS  revenue,
        `rewards.predict_q_amt_outstream_video` as outstream,
        `early_payments.early_payment` AS early_payment
    '''
    service_name = 'Видео'
    synchronizer_class = BaseVideoActualDataSynchronizer


class BaseMediaActualDataLoader(BaseActualDataWithEarlyPaymentLoader):
    service_name = 'Медийка'
    synchronizer_class = BaseMediaActualDataSynchronizer
