from crm.agency_cabinet.common.consts import ContractType, CalculatorServiceType
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.actual.synchronizer import \
    BaseBusinessActualDataSynchronizer as BusinessActualDataSynchronizer, BaseActualDataSynchronizer


class BaseBusinessActualDataSynchronizer(BusinessActualDataSynchronizer):
    service = CalculatorServiceType.business.value
    contract_type = ContractType.base.value

    GRADE_META_INFO = {
        'D': {
            'threshold_start': 0
        },
        'C': {
            'threshold_start': 4000
        },
        'B': {
            'threshold_start': 20000
        },
        'A': {
            'threshold_start': 65000
        },
    }


class BaseDirectActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.direct.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'revenue': 'revenue',
        'early_payment': 'early_payment',
        'rsya': 'predict_m_amt_rsya',
        'conversion_autostrategy': 'predict_q_amt_auto_Q3',
        'key_goals': 'predict_q_amt_goal_Q3',
        'metrica': 'predict_q_amt_metrika',
        'retargeting': 'predict_q_amt_retargeting'
    }


class BaseZenActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.zen.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'revenue': 'revenue',
    }


class BaseVideoActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.video.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'early_payment': 'early_payment',
        'revenue': 'revenue',
        'outstream': 'outstream'
    }


class BaseMediaActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.media.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'early_payment': 'early_payment',
        'revenue': 'revenue',
    }
