from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.actual.loader import BaseActualDataLoader, \
    BaseActualDataWithEarlyPaymentLoader
from .synchronizer import ProfMediaActualDataSynchronizer, ProfVideoActualDataSynchronizer, \
    ProfZenActualDataSynchronizer, ProfDirectActualDataSynchronizer, ProfBusinessActualDataSynchronizer


class ProfBusinessActualDataLoader(BaseActualDataLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_m_amt_prof_yab_a_90k` AS predict_business_grade_a,
        `predict_m_amt_prof_yab_b_40k_90k` as predict_business_grade_b,
        `predict_m_amt_prof_yab_c_3500_40k` as predict_business_grade_c,
        `predict_m_amt_prof_yab_d_3500` as predict_business_grade_d
    '''
    service_name = 'Справочник'
    synchronizer_class = ProfBusinessActualDataSynchronizer


class ProfMediaActualDataLoader(BaseActualDataWithEarlyPaymentLoader):
    service_name = 'Медийка'
    COLUMNS = '''
        `dt` AS dt,
        `early_payments.early_payment` AS early_payment,
        `rewards.predict_amt_prev` AS revenue_prev,
        `rewards.predict_amt` AS revenue,
    '''
    synchronizer_class = ProfMediaActualDataSynchronizer


class ProfVideoActualDataLoader(BaseActualDataWithEarlyPaymentLoader):
    service_name = 'Видео'
    COLUMNS = '''
        `dt` AS dt,
        `early_payments.early_payment` AS early_payment,
        `rewards.predict_amt_prev` AS revenue_prev,
        `rewards.predict_amt` AS revenue,
        `rewards.predict_q_amt_outstream_video` AS revenue_outstream_video
    '''
    synchronizer_class = ProfVideoActualDataSynchronizer


# TODO move to loader.py
class ProfZenActualDataLoader(BaseActualDataWithEarlyPaymentLoader):
    service_name = 'Дзен'
    COLUMNS = '''
        `dt` AS dt,
        `rewards.predict_amt_prev` AS revenue_prev,
        `rewards.predict_amt` AS revenue
    '''
    synchronizer_class = ProfZenActualDataSynchronizer


class ProfDirectActualDataLoader(BaseActualDataWithEarlyPaymentLoader):
    service_name = 'Директ'
    COLUMNS = '''
        `dt` AS dt,
        `early_payments.early_payment` AS early_payment,
        `predict_amt` AS  revenue,
        `predict_m_amt_rsya_prof` as predict_m_amt_rsya,
        `predict_q_amt_auto_Q3` as predict_q_amt_auto_Q3,
        `predict_q_amt_goal_Q3` as predict_q_amt_goal_Q3,
        `predict_q_amt_metrika` as predict_q_amt_metrika,
        `predict_q_amt_video_cpc_Q3` as predict_q_amt_video_cpc_Q3,
        `predict_q_amt_smart_banner` as predict_q_amt_smart_banner,
        `predict_q_amt_rmp` as predict_q_amt_rmp,
        `predict_q_amt_retargeting` as predict_q_amt_retargeting,
        `predict_q_amt_k50` as predict_q_amt_k50,
        `predict_q_amt_product_gallery` as predict_q_amt_product_gallery,
        `predict_q_amt_search_autotargeting_not_uac` as predict_q_amt_search_autotargeting_not_uac,
        `predict_m_uniqd_prof_d_150k` as predict_m_uniqd_prof_d_150k,
        `predict_m_amt_prof_d_150k` as predict_m_amt_prof_d_150k,
        `predict_m_uniqd_prof_c_150k_800k` as predict_m_uniqd_prof_c_150k_800k,
        `predict_m_amt_prof_c_150k_800k` as predict_m_amt_prof_c_150k_800k,
        `predict_m_uniqd_prof_b_800k_5m` as predict_m_uniqd_prof_b_800k_5m,
        `predict_m_amt_prof_b_800k_5m` as predict_m_amt_prof_b_800k_5m,
        `predict_m_uniqd_prof_a_5m` as predict_m_uniqd_prof_a_5m,
        `predict_m_amt_prof_a_5m` as predict_m_amt_prof_a_5m
    '''
    synchronizer_class = ProfDirectActualDataSynchronizer
