from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.actual.synchronizer import \
    BaseBusinessActualDataSynchronizer, BaseActualDataSynchronizer
from crm.agency_cabinet.common.consts import ContractType, CalculatorServiceType


class ProfBusinessActualDataSynchronizer(BaseBusinessActualDataSynchronizer):
    service = CalculatorServiceType.business.value
    contract_type = ContractType.prof.value

    GRADE_META_INFO = {
        'D': {
            'threshold_start': 0
        },
        'C': {
            'threshold_start': 3500
        },
        'B': {
            'threshold_start': 40000
        },
        'A': {
            'threshold_start': 90000
        },
    }


class ProfMediaActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.media.value
    contract_type = ContractType.prof.value
    INDEX_ID_TO_YT_COLUMN_MAP = {
        'early_payment': 'early_payment',
        'revenue': 'revenue',
        'revenue_prev': 'revenue_prev',
    }


class ProfVideoActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.video.value
    contract_type = ContractType.prof.value
    INDEX_ID_TO_YT_COLUMN_MAP = {
        'early_payment': 'early_payment',
        'revenue': 'revenue',
        'revenue_prev': 'revenue_prev',
        'outstream': 'outstream'
    }


class ProfZenActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.zen.value
    contract_type = ContractType.prof.value
    INDEX_ID_TO_YT_COLUMN_MAP = {
        'revenue': 'revenue',
        'revenue_prev': 'revenue_prev',
    }


class ProfDirectActualDataSynchronizer(BaseActualDataSynchronizer):
    service = CalculatorServiceType.direct.value
    contract_type = ContractType.prof.value
    INDEX_ID_TO_YT_COLUMN_MAP = {
        'early_payment': 'early_payment',
        'rsya': 'predict_m_amt_rsya',
        'conversion_autostrategy': 'predict_q_amt_auto_Q3',
        'key_goals': 'predict_q_amt_goal_Q3',
        'metrica': 'predict_q_amt_metrika',
        'video_cpc': 'predict_q_amt_video_cpc_Q3',
        'smart_banners': 'predict_q_amt_smart_banner',
        'rmp': 'predict_q_amt_rmp',
        'retargeting': 'predict_q_amt_retargeting',
        'k50': 'predict_q_amt_k50',
        'product_gallery': 'predict_q_amt_product_gallery',
        'search_autotargeting': 'predict_q_amt_search_autotargeting_not_uac'
    }

    GRADE_TO_YT_COLUMN_MAP = {
        'D': {
            'domains_count': 'predict_m_uniqd_prof_d_150k',
            'revenue_average': 'predict_m_amt_prof_d_150k',
        },

        'C': {
            'domains_count': 'predict_m_uniqd_prof_c_150k_800k',
            'revenue_average': 'predict_m_amt_prof_c_150k_800k',
        },

        'B': {
            'domains_count': 'predict_m_uniqd_prof_b_800k_5m',
            'revenue_average': 'predict_m_amt_prof_b_800k_5m',
        },

        'A': {
            'domains_count': 'predict_m_uniqd_prof_a_5m',
            'revenue_average': 'predict_m_amt_prof_a_5m'
        }
    }

    GRADE_META_INFO = {
        'D': {
            'threshold_start': 0
        },
        'C': {
            'threshold_start': 150000
        },
        'B': {
            'threshold_start': 800000
        },
        'A': {
            'threshold_start': 5000000
        },
    }

    use_average_grade=True
