from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.predicts.aggregator.synchronizer import \
    MetaAggregatorPredictsSynchronizer, AggregatorBusinessPredictsSynchronizer
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.predicts.loader import BasePredictsLoader
from crm.agency_cabinet.common.consts import CalculatorServiceType


class MetaAggregatorBasePredictsLoader(BasePredictsLoader):
    synchronizer_class = MetaAggregatorPredictsSynchronizer

    service_name = CalculatorServiceType.aggregator.value

    YQL_QUERY = '''
        use hahn;

        DECLARE $predicts_table_path AS String;
        DECLARE $period_from AS String;
        DECLARE $period_to AS String;

        SELECT
            contract_id,
            AGGREGATE_LIST(
                        AsStruct(
                            `dt` AS dt,
                            `predict_m_uniqd_aggr_a_5m` AS predict_m_uniqd_aggr_a_5m,
                            `predict_m_amt_aggr_a_5m` AS predict_m_amt_aggr_a_5m,
                            `predict_m_uniqd_aggr_b_1m_5m` AS predict_m_uniqd_aggr_b_1m_5m,
                            `predict_m_amt_aggr_b_1m_5m` AS predict_m_amt_aggr_b_1m_5m,
                            `predict_m_uniqd_aggr_c_150k_1m` AS predict_m_uniqd_aggr_c_150k_1m,
                            `predict_m_amt_aggr_c_150k_1m` AS predict_m_amt_aggr_c_150k_1m,
                            `predict_m_uniqd_aggr_d_150k` AS predict_m_uniqd_aggr_d_150k,
                            `predict_m_amt_aggr_d_150k` AS predict_m_amt_aggr_d_150k,
                            `predict_q_amt_autostrategy` AS predict_q_amt_autostrategy,
                            `predict_amt` AS revenue,
                            `predict_q_amt_k50` AS predict_q_amt_k50,
                            `predict_q_amt_goal` AS predict_q_amt_goal,
                            `predict_q_amt_metrika` AS predict_q_amt_metrika,
                            `predict_q_amt_retargeting` AS predict_q_amt_retargeting,
                            `predict_m_amt_rsya` AS predict_m_amt_rsya,
                            `predict_q_amt_search_autotargeting_not_uac` AS predict_q_amt_search_autotargeting_not_uac,
                            `predict_amt_media_video_zen` AS predict_amt_media_video_zen,
                            `amt_media_video_zen_prev` AS amt_media_video_zen_prev
                        )
            )
        FROM
        (
            SELECT
                contract_id,
                dt,
                SUM(predict_q_amt_autostrategy) AS predict_q_amt_autostrategy,
                SUM(predict_amt) AS predict_amt,
                SUM(predict_q_amt_k50) AS predict_q_amt_k50,
                SUM(predict_q_amt_goal) AS predict_q_amt_goal,
                SUM(predict_q_amt_metrika) AS predict_q_amt_metrika,
                SUM(predict_q_amt_retargeting) AS predict_q_amt_retargeting,
                SUM(predict_m_amt_rsya) AS predict_m_amt_rsya,
                SUM(predict_q_amt_search_autotargeting_not_uac) AS predict_q_amt_search_autotargeting_not_uac,
                SUM_IF(predict_amt, discount_name in ('Медийка', 'Видео', 'Дзен')) AS predict_amt_media_video_zen,
                SUM_IF(predict_amt_prev, discount_name in ('Медийка', 'Видео', 'Дзен')) AS amt_media_video_zen_prev,
                SUM(predict_m_uniqd_aggr_a_5m) AS predict_m_uniqd_aggr_a_5m,
                SUM(predict_m_amt_aggr_a_5m) AS predict_m_amt_aggr_a_5m,
                SUM(predict_m_uniqd_aggr_b_1m_5m) AS predict_m_uniqd_aggr_b_1m_5m,
                SUM(predict_m_amt_aggr_b_1m_5m) AS predict_m_amt_aggr_b_1m_5m,
                SUM(predict_m_uniqd_aggr_c_150k_1m) AS predict_m_uniqd_aggr_c_150k_1m,
                SUM(predict_m_amt_aggr_c_150k_1m) AS predict_m_amt_aggr_c_150k_1m,
                SUM(predict_m_uniqd_aggr_d_150k) AS predict_m_uniqd_aggr_d_150k,
                SUM(predict_m_amt_aggr_d_150k) AS predict_m_amt_aggr_d_150k
            FROM
               $predicts_table_path
            WHERE
                discount_name in ('Медийка', 'Видео', 'Дзен', 'Директ')
                AND contract_category=='aggr'
                AND dt<$period_to
                AND dt>=$period_from
            GROUP BY contract_id, dt
        )
        GROUP BY contract_id
        ;
    '''

    def yql_query(self):
        return self.YQL_QUERY


class AggregatorBusinessPredictsLoader(BasePredictsLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_m_amt_aggr_yab_a_65k` AS predict_business_grade_a,
        `predict_m_amt_aggr_yab_b_20k_65k` as predict_business_grade_b,
        `predict_m_amt_aggr_yab_c_3500_20k` as predict_business_grade_c,
        `predict_m_amt_aggr_yab_d_3500` as predict_business_grade_d

    '''
    service_name = 'Справочник'
    synchronizer_class = AggregatorBusinessPredictsSynchronizer
