from crm.agency_cabinet.common.consts import ContractType, CalculatorServiceType
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.predicts.synchronizer import \
    BasePredictsSynchronizer, BaseBusinessPredictsSynchronizer


class MetaAggregatorPredictsSynchronizer(BasePredictsSynchronizer):
    service = CalculatorServiceType.aggregator.value
    contract_type = ContractType.aggregator.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'conversion_autostrategy': 'predict_q_amt_autostrategy',
        'early_payment': 'revenue',
        'k50': 'predict_q_amt_k50',
        'key_goals': 'predict_q_amt_goal',
        'metrica': 'predict_q_amt_metrika',
        'retargeting': 'predict_q_amt_retargeting',
        'revenue_without_direct': 'predict_amt_media_video_zen',
        'revenue_without_direct_prev': 'amt_media_video_zen_prev',
        'rsya': 'predict_m_amt_rsya',
        'search_autotargeting': 'predict_q_amt_search_autotargeting_not_uac',
    }

    GRADE_TO_YT_COLUMN_MAP = {
        'A': {
            'domains_count': 'predict_m_uniqd_aggr_a_5m',
            'revenue_average': 'predict_m_amt_aggr_a_5m'
        },
        'B': {
            'domains_count': 'predict_m_uniqd_aggr_b_1m_5m',
            'revenue_average': 'predict_m_amt_aggr_b_1m_5m',
        },
        'C': {
            'domains_count': 'predict_m_uniqd_aggr_c_150k_1m',
            'revenue_average': 'predict_m_amt_aggr_c_150k_1m',
        },
        'D': {
            'domains_count': 'predict_m_uniqd_aggr_d_150k',
            'revenue_average': 'predict_m_amt_aggr_d_150k',
        }
    }

    GRADE_META_INFO = {
        'A': {
            'threshold_start': 5000000
        },
        'B': {
            'threshold_start': 1000000
        },
        'C': {
            'threshold_start': 150000
        },
        'D': {
            'threshold_start': 0
        }
    }

    use_average_grade=True


class AggregatorBusinessPredictsSynchronizer(BaseBusinessPredictsSynchronizer):
    service = CalculatorServiceType.business.value
    contract_type = ContractType.aggregator.value

    GRADE_META_INFO = {
        'D': {
            'threshold_start': 0
        },
        'C': {
            'threshold_start': 3500
        },
        'B': {
            'threshold_start': 20000
        },
        'A': {
            'threshold_start': 65000
        },
    }
