from .synchronizer import BaseBusinessPredictsSynchronizer, BaseMediaPredictsSynchronizer, \
    BaseVideoPredictsSynchronizer, BaseZenPredictsSynchronizer, BaseDirectPredictsSynchronizer
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.predicts.loader import BasePredictsLoader


class BaseMediaPredictsLoader(BasePredictsLoader):
    service_name = 'Медийка'
    synchronizer_class = BaseMediaPredictsSynchronizer


class BaseVideoPredictsLoader(BasePredictsLoader):
    service_name = 'Видео'
    synchronizer_class = BaseVideoPredictsSynchronizer


class BaseZenPredictsLoader(BasePredictsLoader):
    service_name = 'Дзен'
    synchronizer_class = BaseZenPredictsSynchronizer


class BaseBusinessPredictsLoader(BasePredictsLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_m_amt_base_yab_a_65k` AS predict_business_grade_a,
        `predict_m_amt_base_yab_b_20k_65k` as predict_business_grade_b,
        `predict_m_amt_base_yab_c_4000_20k` as predict_business_grade_c,
        `predict_m_amt_base_yab_d_4000` as predict_business_grade_d
    '''
    service_name = 'Справочник'
    synchronizer_class = BaseBusinessPredictsSynchronizer


class BaseDirectPredictsLoader(BasePredictsLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_amt` AS  revenue,
        `predict_m_amt_rsya` as predict_m_amt_rsya,
        `predict_q_amt_auto_Q3` as predict_q_amt_auto_Q3,
        `predict_q_amt_goal_Q3` as predict_q_amt_goal_Q3,
        `predict_q_amt_metrika` as predict_q_amt_metrika,
        `predict_q_amt_retargeting` as predict_q_amt_retargeting
    '''

    service_name = 'Директ'
    synchronizer_class = BaseDirectPredictsSynchronizer
